/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.lowtechcrafting.inventory.wrapper;

import fi.dy.masa.lowtechcrafting.inventory.IItemHandlerSize;
import fi.dy.masa.lowtechcrafting.inventory.wrapper.InventoryCraftingWrapper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ItemHandlerWrapperCrafter
implements IItemHandler,
IItemHandlerSize,
INBTSerializable<CompoundNBT> {
    private final IItemHandlerModifiable inventoryCraftingGridBase;
    private final IItemHandler inventoryOutputBuffer;
    private final IItemHandler inventoryCraftingOutput;
    private final InventoryCraftingWrapper inventoryCraftingWrapper;

    public ItemHandlerWrapperCrafter(IItemHandlerModifiable inventoryCraftingGridBase, IItemHandler inventoryOutputBuffer, IItemHandler inventoryCraftingOutput, InventoryCraftingWrapper inventoryCraftingWrapper) {
        this.inventoryCraftingGridBase = inventoryCraftingGridBase;
        this.inventoryOutputBuffer = inventoryOutputBuffer;
        this.inventoryCraftingOutput = inventoryCraftingOutput;
        this.inventoryCraftingWrapper = inventoryCraftingWrapper;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public int getItemStackLimit(int slot, ItemStack stack) {
        return 64;
    }

    public int getSlots() {
        return 10;
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot == 0) {
            ItemStack stack = this.inventoryOutputBuffer.getStackInSlot(0);
            if (!stack.func_190926_b()) {
                return stack;
            }
            return this.inventoryCraftingOutput.getStackInSlot(0);
        }
        return this.inventoryCraftingGridBase.getStackInSlot(slot - 1);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot == 0) {
            ItemStack stack = this.inventoryOutputBuffer.getStackInSlot(0);
            if (!simulate) {
                if (stack.func_190926_b()) {
                    stack = this.inventoryCraftingOutput.extractItem(0, 64, false);
                    this.inventoryOutputBuffer.insertItem(0, stack, false);
                }
                return this.inventoryOutputBuffer.extractItem(0, amount, false);
            }
            if (!stack.func_190926_b()) {
                return this.inventoryOutputBuffer.extractItem(0, amount, true);
            }
            return this.inventoryCraftingOutput.extractItem(0, amount, true);
        }
        ItemStack stack = this.inventoryCraftingGridBase.extractItem(slot - 1, amount, simulate);
        if (!simulate) {
            this.inventoryCraftingWrapper.checkUpdateGridCacheForSlot(slot - 1);
        }
        return stack;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        stack = this.inventoryCraftingGridBase.insertItem(slot - 1, stack, simulate);
        if (!simulate) {
            this.inventoryCraftingWrapper.checkUpdateGridCacheForSlot(slot - 1);
        }
        return stack;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return slot != 0;
    }

    public CompoundNBT serializeNBT() {
        return new CompoundNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
    }
}

