/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.lowtechcrafting.inventory.container;

import fi.dy.masa.lowtechcrafting.inventory.ItemHandlerCraftResult;
import fi.dy.masa.lowtechcrafting.inventory.container.base.ContainerCustomSlotClick;
import fi.dy.masa.lowtechcrafting.inventory.container.base.MergeSlotRange;
import fi.dy.masa.lowtechcrafting.inventory.slot.SlotItemHandlerCraftResult;
import fi.dy.masa.lowtechcrafting.inventory.slot.SlotItemHandlerGeneric;
import fi.dy.masa.lowtechcrafting.inventory.wrapper.InventoryCraftingWrapper;
import fi.dy.masa.lowtechcrafting.reference.ModObjects;
import fi.dy.masa.lowtechcrafting.tileentity.TileEntityCrafting;
import fi.dy.masa.lowtechcrafting.util.InventoryUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ContainerCrafting
extends ContainerCustomSlotClick {
    protected final TileEntityCrafting te;
    private final InventoryCraftingWrapper invCraftingGrid;
    private final ItemHandlerCraftResult invCraftResult;
    private final IItemHandler invCraftingWrapper;
    private int craftingSlot;

    public ContainerCrafting(int windowId, PlayerInventory playerInv, PacketBuffer extraData) {
        this(windowId, playerInv.field_70458_d, (TileEntityCrafting)playerInv.field_70458_d.func_130014_f_().func_175625_s(extraData.func_179259_c()));
    }

    public ContainerCrafting(int windowId, PlayerEntity player, TileEntityCrafting te) {
        super(windowId, ModObjects.CONTAINER_TYPE_CRAFTING_TABLE, player, te.getCraftingWrapperInventory());
        this.te = te;
        this.invCraftingGrid = te.getCraftingGridWrapperInventory();
        this.invCraftResult = te.getCraftResultInventory();
        this.invCraftingWrapper = te.getCraftingWrapperInventory();
        this.reAddSlots(8, 84);
    }

    @Override
    public boolean func_75145_c(PlayerEntity player) {
        return !this.te.func_145837_r();
    }

    @Override
    protected void addCustomInventorySlots() {
        this.customInventorySlots = new MergeSlotRange(this.field_75151_b.size(), 10);
        int posX = 30;
        int posY = 17;
        ItemStackHandler invGrid = this.isClient ? new ItemStackHandler(9) : new InvWrapper((IInventory)this.invCraftingGrid);
        ItemStackHandler invOutput = this.isClient ? new ItemStackHandler(1) : this.invCraftingWrapper;
        this.craftingSlot = this.field_75151_b.size();
        this.func_75146_a((Slot)new SlotItemHandlerCraftResult(this.invCraftingGrid, this.invCraftResult, (IItemHandler)invOutput, 0, 124, 35, this.player));
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 3; ++c) {
                this.func_75146_a((Slot)new SlotItemHandlerGeneric((IItemHandler)invGrid, r * 3 + c, posX + c * 18, posY + r * 18));
            }
        }
        this.invCraftingGrid.func_70296_d();
    }

    @Override
    protected void shiftClickSlot(int slotNum, PlayerEntity player) {
        block2: {
            if (slotNum != this.craftingSlot) {
                super.shiftClickSlot(slotNum, player);
                return;
            }
            SlotItemHandlerGeneric slot = this.getSlotItemHandler(slotNum);
            if (slot == null || !slot.func_75216_d()) break block2;
            ItemStack stackOrig = slot.func_75211_c().func_77946_l();
            int num = 64;
            while (num-- > 0 && this.transferStackFromSlot(player, slotNum) && InventoryUtils.areItemStacksEqual(stackOrig, slot.func_75211_c())) {
            }
        }
    }

    @Override
    protected void rightClickSlot(int slotNum, PlayerEntity player) {
        if (slotNum == this.craftingSlot) {
            super.leftClickSlot(slotNum, player);
        } else {
            super.rightClickSlot(slotNum, player);
        }
    }

    @Override
    public void func_75142_b() {
        this.invCraftingGrid.updateCraftingOutput();
        super.func_75142_b();
    }

    @Override
    public ItemStack func_184996_a(int slotNum, int dragType, ClickType clickType, PlayerEntity player) {
        super.func_184996_a(slotNum, dragType, clickType, player);
        if (!this.isClient && slotNum == this.craftingSlot) {
            this.syncSlotToClient(this.craftingSlot);
            this.syncCursorStackToClient();
        }
        return ItemStack.field_190927_a;
    }
}

