/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.lowtechcrafting.inventory.wrapper;

import fi.dy.masa.lowtechcrafting.inventory.ItemHandlerCraftResult;
import fi.dy.masa.lowtechcrafting.inventory.ItemStackHandlerTileEntity;
import fi.dy.masa.lowtechcrafting.util.InventoryUtils;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;

public class InventoryCraftingWrapper
extends CraftingInventory
implements INBTSerializable<CompoundNBT> {
    private final int inventoryWidth;
    private final int inventoryHeight;
    private final ItemHandlerCraftResult craftResult;
    private final NonNullList<ItemStack> gridCache;
    private final ItemStackHandlerTileEntity craftMatrix;
    private final Supplier<World> worldSupplier;
    private Optional<ICraftingRecipe> lastCraftedRecipe = Optional.empty();
    @Nullable
    private ICraftingRecipe recipe;
    @Nullable
    private World world;
    private boolean inhibitResultUpdate;
    private boolean gridDirty;

    public InventoryCraftingWrapper(int width, int height, ItemStackHandlerTileEntity craftMatrix, ItemHandlerCraftResult resultInventory, Supplier<World> worldSupplier) {
        super(null, 0, 0);
        this.inventoryWidth = width;
        this.inventoryHeight = height;
        this.craftMatrix = craftMatrix;
        this.craftResult = resultInventory;
        this.gridCache = NonNullList.func_191197_a((int)(width * height), (Object)ItemStack.field_190927_a);
        this.worldSupplier = worldSupplier;
        this.updateGridCache();
    }

    @Nullable
    private World getWorld() {
        if (this.world == null) {
            this.world = this.worldSupplier.get();
        }
        return this.world;
    }

    public void setInhibitResultUpdate(boolean inhibitUpdate) {
        this.inhibitResultUpdate = inhibitUpdate;
    }

    public int func_174923_h() {
        return this.inventoryHeight;
    }

    public int func_174922_i() {
        return this.inventoryWidth;
    }

    public int func_70302_i_() {
        return this.craftMatrix.getSlots();
    }

    public ItemStack func_70301_a(int slot) {
        return slot >= this.func_70302_i_() ? ItemStack.field_190927_a : this.craftMatrix.getStackInSlot(slot);
    }

    public boolean func_191420_l() {
        int invSize = this.craftMatrix.getSlots();
        for (int slot = 0; slot < invSize; ++slot) {
            if (this.func_70301_a(slot).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void updateGridCache() {
        for (int slot = 0; slot < this.craftMatrix.getSlots(); ++slot) {
            this.checkUpdateGridCacheForSlot(slot);
        }
    }

    public void checkUpdateGridCacheForSlot(int slot) {
        ItemStack stackNew = this.craftMatrix.getStackInSlot(slot);
        if (!InventoryUtils.areItemStacksEqual((ItemStack)this.gridCache.get(slot), stackNew)) {
            this.gridCache.set(slot, (Object)(stackNew.func_190926_b() ? ItemStack.field_190927_a : stackNew.func_77946_l()));
            this.gridDirty = true;
        }
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.craftMatrix.extractItem(slot, this.craftMatrix.getStackInSlot(slot).func_190916_E(), false);
        if (!stack.func_190926_b()) {
            this.gridCache.set(slot, (Object)ItemStack.field_190927_a);
            this.gridDirty = true;
        }
        return stack;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stackOrig = this.craftMatrix.getStackInSlot(slot);
        ItemStack stackReturn = stackOrig.func_77946_l();
        amount = Math.min(amount, stackOrig.func_190916_E());
        stackReturn.func_190920_e(amount);
        stackOrig.func_190918_g(amount);
        this.craftMatrix.setStackInSlot(slot, stackOrig);
        this.checkUpdateGridCacheForSlot(slot);
        return stackReturn;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.craftMatrix.setStackInSlot(slot, stack);
        this.checkUpdateGridCacheForSlot(slot);
    }

    public int func_70297_j_() {
        return this.craftMatrix.getSlotLimit(0);
    }

    public void func_174888_l() {
        for (int slot = 0; slot < this.craftMatrix.getSlots(); ++slot) {
            this.craftMatrix.setStackInSlot(slot, ItemStack.field_190927_a);
        }
        this.updateGridCache();
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    private void setCraftResult(ItemStack stack) {
        this.craftResult.setStackInSlot(0, stack.func_190926_b() ? ItemStack.field_190927_a : stack.func_77946_l());
    }

    public void updateCraftingOutput() {
        World world = this.getWorld();
        if (this.gridDirty && !this.inhibitResultUpdate && world != null && !world.field_72995_K) {
            Optional optional = this.lastCraftedRecipe;
            if (!optional.isPresent() || !optional.get().func_77569_a((IInventory)this, world)) {
                optional = world.func_73046_m().func_199529_aN().func_215371_a(IRecipeType.field_222149_a, (IInventory)this, world);
            }
            ItemStack stack = ItemStack.field_190927_a;
            if (optional.isPresent()) {
                ICraftingRecipe recipe = (ICraftingRecipe)optional.get();
                this.craftResult.setRecipe(recipe);
                this.recipe = recipe;
                stack = recipe.func_77572_b((IInventory)this);
            }
            this.setCraftResult(stack);
            this.gridDirty = false;
        }
    }

    public void onCraft() {
        if (this.recipe != null) {
            this.lastCraftedRecipe = Optional.of(this.recipe);
        }
    }

    public void func_194018_a(RecipeItemHelper recipeItemHelper) {
        int invSize = this.craftMatrix.getSlots();
        for (int slot = 0; slot < invSize; ++slot) {
            recipeItemHelper.func_195932_a(this.craftMatrix.getStackInSlot(slot));
        }
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public int getField(int id) {
        return 0;
    }

    public void setField(int id, int value) {
    }

    public int getFieldCount() {
        return 0;
    }

    public CompoundNBT serializeNBT() {
        return this.craftMatrix.serializeNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.craftMatrix.deserializeNBT(nbt);
        this.updateGridCache();
    }
}

