/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.lowtechcrafting.network.message;

import fi.dy.masa.lowtechcrafting.LowTechCrafting;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.EncoderException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.util.IItemProvider;

public class ByteBufUtilsLTC {
    public static void writeItemStackToBuffer(ByteBuf buf, ItemStack stack) {
        if (stack.func_190926_b()) {
            buf.writeInt(-1);
            return;
        }
        buf.writeInt(Item.func_150891_b((Item)stack.func_77973_b()));
        buf.writeInt(stack.func_190916_E());
        CompoundNBT tag = stack.func_77973_b().getShareTag(stack);
        ByteBufUtilsLTC.writeNBTTagCompoundToBuffer(buf, tag);
    }

    public static ItemStack readItemStackFromBuffer(ByteBuf buf) throws IOException {
        ItemStack stack = ItemStack.field_190927_a;
        int id = buf.readInt();
        if (id >= 0) {
            int stackSize = buf.readInt();
            stack = new ItemStack((IItemProvider)Item.func_150899_d((int)id), stackSize);
            stack.func_77982_d(ByteBufUtilsLTC.readNBTTagCompoundFromBuffer(buf));
        }
        return stack;
    }

    public static void writeNBTTagCompoundToBuffer(ByteBuf buf, CompoundNBT tag) {
        if (tag == null) {
            buf.writeByte(0);
            return;
        }
        try {
            CompressedStreamTools.func_74800_a((CompoundNBT)tag, (DataOutput)new ByteBufOutputStream(buf));
        }
        catch (IOException ioexception) {
            LowTechCrafting.logger.error("IOException while trying to write a NBTTagCompound to ByteBuf");
            throw new EncoderException((Throwable)ioexception);
        }
    }

    public static CompoundNBT readNBTTagCompoundFromBuffer(ByteBuf buf) throws IOException {
        int i = buf.readerIndex();
        byte b0 = buf.readByte();
        if (b0 == 0) {
            return null;
        }
        buf.readerIndex(i);
        return CompressedStreamTools.func_152456_a((DataInput)new ByteBufInputStream(buf), (NBTSizeTracker)new NBTSizeTracker(0x200000L));
    }
}

