/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.lowtechcrafting.network.message;

import fi.dy.masa.lowtechcrafting.LowTechCrafting;
import fi.dy.masa.lowtechcrafting.inventory.container.base.ContainerBase;
import fi.dy.masa.lowtechcrafting.network.message.ByteBufUtilsLTC;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSyncSlot {
    private int windowId;
    private int slotNum;
    private ItemStack stack = ItemStack.field_190927_a;

    public MessageSyncSlot(PacketBuffer buf) {
        try {
            this.windowId = buf.func_150792_a();
            this.slotNum = buf.readShort();
            this.stack = ByteBufUtilsLTC.readItemStackFromBuffer((ByteBuf)buf);
        }
        catch (IOException e) {
            LowTechCrafting.logger.warn("MessageSyncSlot: Exception while reading data from buffer", (Throwable)e);
        }
    }

    public MessageSyncSlot(int windowId, int slotNum, ItemStack stack) {
        this.windowId = windowId;
        this.slotNum = slotNum;
        this.stack = stack;
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_150787_b(this.windowId);
        buf.writeShort(this.slotNum);
        ByteBufUtilsLTC.writeItemStackToBuffer((ByteBuf)buf, this.stack);
    }

    public void handle(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            if (ctx.getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
                LowTechCrafting.logger.error("Wrong side in MessageSyncSlot: " + ctx.getDirection());
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            if (mc == null || mc.field_71439_g == null) {
                LowTechCrafting.logger.error("Minecraft or player was null in MessageSyncSlot");
                return;
            }
            if (mc.field_71439_g.field_71070_bA instanceof ContainerBase && this.windowId == mc.field_71439_g.field_71070_bA.field_75152_c) {
                ((ContainerBase)mc.field_71439_g.field_71070_bA).syncStackInSlot(this.slotNum, this.stack);
            }
            ctx.setPacketHandled(true);
        });
    }
}

