/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.lowtechcrafting.tileentity;

import com.mojang.authlib.GameProfile;
import fi.dy.masa.lowtechcrafting.inventory.ItemHandlerCraftResult;
import fi.dy.masa.lowtechcrafting.inventory.ItemStackHandlerTileEntity;
import fi.dy.masa.lowtechcrafting.inventory.container.ContainerCrafting;
import fi.dy.masa.lowtechcrafting.inventory.wrapper.InventoryCraftingWrapper;
import fi.dy.masa.lowtechcrafting.inventory.wrapper.ItemHandlerWrapperCrafter;
import fi.dy.masa.lowtechcrafting.reference.ModObjects;
import fi.dy.masa.lowtechcrafting.util.InventoryUtils;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityCrafting
extends TileEntity
implements INamedContainerProvider {
    private final ItemStackHandlerTileEntity itemHandlerCraftingGrid = new ItemStackHandlerTileEntity(0, 9, 64, false, "Items", this);
    private final ItemStackHandlerTileEntity itemHandlerOutputBuffer = new ItemStackHandlerTileEntity(1, 1, 64, false, "ItemsOut", this);
    private final InventoryCraftingWrapper inventoryCrafting;
    private final ItemHandlerCraftResult itemHandlerCraftResult = new ItemHandlerCraftResult(() -> ((TileEntityCrafting)this).func_145831_w(), this::getPlayer, () -> ((TileEntityCrafting)this).func_174877_v());
    private final ItemHandlerWrapperCrafter itemHandlerWrapperCrafter;
    private final IItemHandler itemHandlerExternal;
    private final LazyOptional<IItemHandler> inventoryCapability;
    private final String tileEntityName;
    private String customInventoryName;
    private FakePlayer fakePlayer;

    public TileEntityCrafting() {
        super(ModObjects.TILE_TYPE_CRAFTING_TABLE);
        this.tileEntityName = "crafting_table";
        this.inventoryCrafting = new InventoryCraftingWrapper(3, 3, this.itemHandlerCraftingGrid, this.itemHandlerCraftResult, () -> ((TileEntityCrafting)this).func_145831_w());
        this.itemHandlerCraftResult.setCraftMatrix(this.inventoryCrafting);
        this.itemHandlerWrapperCrafter = new ItemHandlerWrapperCrafter(this.itemHandlerCraftingGrid, this.itemHandlerOutputBuffer, this.itemHandlerCraftResult, this.inventoryCrafting);
        this.itemHandlerExternal = new ItemHandlerWrapperCrafterExternal(this.itemHandlerWrapperCrafter);
        this.inventoryCapability = LazyOptional.of(() -> this.itemHandlerExternal);
    }

    public InventoryCraftingWrapper getCraftingGridWrapperInventory() {
        return this.inventoryCrafting;
    }

    public ItemHandlerCraftResult getCraftResultInventory() {
        return this.itemHandlerCraftResult;
    }

    public IItemHandler getCraftingWrapperInventory() {
        return this.itemHandlerWrapperCrafter;
    }

    public void dropInventories() {
        InventoryUtils.dropInventoryContentsInWorld(this.func_145831_w(), this.func_174877_v(), this.itemHandlerCraftingGrid);
        InventoryUtils.dropInventoryContentsInWorld(this.func_145831_w(), this.func_174877_v(), this.itemHandlerOutputBuffer);
    }

    @Nonnull
    protected FakePlayer getPlayer() {
        if (this.fakePlayer == null && this.func_145831_w() instanceof ServerWorld) {
            int dim = this.func_145831_w().func_230315_m_().hashCode();
            this.fakePlayer = FakePlayerFactory.get((ServerWorld)((ServerWorld)this.func_145831_w()), (GameProfile)new GameProfile(new UUID(dim, dim), "lowtechcrafting:" + this.tileEntityName));
        }
        return this.fakePlayer;
    }

    public void readFromNBTCustom(CompoundNBT nbt) {
        this.itemHandlerOutputBuffer.deserializeNBT(nbt);
        this.inventoryCrafting.deserializeNBT(nbt);
        if (nbt.func_150297_b("CustomName", 8)) {
            this.customInventoryName = nbt.func_74779_i("CustomName");
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.readFromNBTCustom(tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_197643_a(this.itemHandlerOutputBuffer.serializeNBT());
        nbt.func_197643_a(this.inventoryCrafting.serializeNBT());
        if (this.hasCustomName()) {
            nbt.func_74778_a("CustomName", this.customInventoryName);
        }
        return nbt;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("x", this.func_174877_v().func_177958_n());
        nbt.func_74768_a("y", this.func_174877_v().func_177956_o());
        nbt.func_74768_a("z", this.func_174877_v().func_177952_p());
        return nbt;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        if (this.func_145831_w() != null) {
            return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189517_E_());
        }
        return null;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCapability.cast();
        }
        return super.getCapability(capability, side);
    }

    public void inventoryChanged(int inventoryId, int slot) {
    }

    public void setInventoryName(String name) {
        this.customInventoryName = name;
    }

    public boolean hasCustomName() {
        return this.customInventoryName != null && this.customInventoryName.length() > 0;
    }

    public String getName() {
        return this.hasCustomName() ? this.customInventoryName : "tile." + this.tileEntityName + ".name";
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.getName());
    }

    public Container createMenu(int windowId, PlayerInventory playerInv, PlayerEntity player) {
        return new ContainerCrafting(windowId, player, this);
    }

    public static class ItemHandlerWrapperCrafterExternal
    implements IItemHandler {
        private final IItemHandler inventoryCrafter;

        public ItemHandlerWrapperCrafterExternal(IItemHandler inventoryCrafter) {
            this.inventoryCrafter = inventoryCrafter;
        }

        public int getSlots() {
            return this.inventoryCrafter.getSlots();
        }

        public int getSlotLimit(int slot) {
            return slot == 0 ? this.inventoryCrafter.getSlotLimit(slot) : 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return this.inventoryCrafter.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            if (stack.func_190916_E() > 1) {
                ItemStack stackInsert = stack.func_77946_l();
                stackInsert.func_190920_e(1);
                stackInsert = this.inventoryCrafter.insertItem(slot, stackInsert, simulate);
                if (stackInsert.func_190926_b()) {
                    stack = stack.func_77946_l();
                    stack.func_190918_g(1);
                    return stack;
                }
                return stack;
            }
            return this.inventoryCrafter.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.inventoryCrafter.extractItem(slot, amount, simulate);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return slot != 0 && this.inventoryCrafter.getStackInSlot(slot).func_190926_b();
        }
    }
}

