/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.lowtechcrafting.util;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class EntityUtils {
    public static void dropItemStacksInWorld(World worldIn, BlockPos pos, ItemStack stack, int amountOverride, boolean dropFullStacks) {
        EntityUtils.dropItemStacksInWorld(worldIn, pos, stack, amountOverride, dropFullStacks, true);
    }

    public static void dropItemStacksInWorld(World worldIn, BlockPos pos, ItemStack stack, int amountOverride, boolean dropFullStacks, boolean randomMotion) {
        double x = (double)worldIn.field_73012_v.nextFloat() * -0.5 + 0.75 + (double)pos.func_177958_n();
        double y = (double)worldIn.field_73012_v.nextFloat() * -0.5 + 0.75 + (double)pos.func_177956_o();
        double z = (double)worldIn.field_73012_v.nextFloat() * -0.5 + 0.75 + (double)pos.func_177952_p();
        EntityUtils.dropItemStacksInWorld(worldIn, new Vector3d(x, y, z), stack, amountOverride, dropFullStacks, randomMotion);
    }

    public static void dropItemStacksInWorld(World worldIn, Vector3d pos, ItemStack stack, int amountOverride, boolean dropFullStacks, boolean randomMotion) {
        int max;
        int amount = stack.func_190916_E();
        int num = max = stack.func_77976_d();
        if (amountOverride > 0) {
            amount = amountOverride;
        }
        while (amount > 0) {
            Vector3d motion;
            if (!dropFullStacks) {
                num = Math.min(worldIn.field_73012_v.nextInt(23) + 10, max);
            }
            num = Math.min(num, amount);
            amount -= num;
            ItemStack dropStack = stack.func_77946_l();
            dropStack.func_190920_e(num);
            ItemEntity item = new ItemEntity(worldIn, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, dropStack);
            item.func_174869_p();
            if (randomMotion) {
                double motionScale = 0.04;
                motion = new Vector3d(worldIn.field_73012_v.nextGaussian() * motionScale, worldIn.field_73012_v.nextGaussian() * motionScale + 0.3, worldIn.field_73012_v.nextGaussian() * motionScale);
            } else {
                motion = new Vector3d(0.0, 0.0, 0.0);
            }
            item.func_213317_d(motion);
            worldIn.func_217376_c((Entity)item);
        }
    }
}

