/*
 * Decompiled with CFR 0.152.
 */
package drunkblood.luckyore.crafting.condition;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import drunkblood.luckyore.config.LuckyOreConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class ConfigEnableCondition
implements ICondition {
    private static final ResourceLocation ID = new ResourceLocation("luckyore", "enabled_by_cfg");
    private static final Map<String, Supplier<Boolean>> configs = new HashMap<String, Supplier<Boolean>>();
    private final String configKey;

    public ConfigEnableCondition(String configKey) {
        this.configKey = configKey;
    }

    public ResourceLocation getID() {
        return ID;
    }

    public boolean test() {
        return configs.get(this.configKey).get();
    }

    static {
        configs.put("lucky_diamond_ore", () -> LuckyOreConfig.lucky_diamond_ore_enabled);
        configs.put("lucky_emerald_ore", () -> LuckyOreConfig.lucky_emerald_ore_enabled);
        configs.put("lucky_lapis_ore", () -> LuckyOreConfig.lucky_lapis_ore_enabled);
        configs.put("lucky_redstone_ore", () -> LuckyOreConfig.lucky_redstone_ore_enabled);
        configs.put("nether_lucky_ore", () -> LuckyOreConfig.nether_lucky_ore_enabled);
    }

    public static class Serializer
    implements IConditionSerializer<ConfigEnableCondition> {
        public void write(JsonObject json, ConfigEnableCondition value) {
            json.addProperty("enabled_by_cfg", value.configKey);
        }

        public ConfigEnableCondition read(JsonObject json) {
            if (!json.has("enabled_by_cfg") || !configs.containsKey(json.get("enabled_by_cfg").getAsString())) {
                throw new JsonParseException("Invalid config condition!");
            }
            return new ConfigEnableCondition(json.get("enabled_by_cfg").getAsString());
        }

        public ResourceLocation getID() {
            return ID;
        }
    }
}

