/*
 * Decompiled with CFR 0.152.
 */
package drunkblood.luckyore.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class ClientConfig {
    public final ForgeConfigSpec.BooleanValue lucky_enchantment_enabled;
    public final ForgeConfigSpec.BooleanValue lucky_diamond_ore_enabled;
    public final ForgeConfigSpec.BooleanValue lucky_emerald_ore_enabled;
    public final ForgeConfigSpec.BooleanValue lucky_lapis_ore_enabled;
    public final ForgeConfigSpec.BooleanValue lucky_redstone_ore_enabled;
    public final ForgeConfigSpec.BooleanValue nether_lucky_ore_enabled;
    public final ForgeConfigSpec.ConfigValue<Integer> lucky_ore_vein_count;
    public final ForgeConfigSpec.ConfigValue<Integer> lucky_ore_vein_size;
    public final ForgeConfigSpec.ConfigValue<Integer> lucky_ore_min_y;
    public final ForgeConfigSpec.ConfigValue<Integer> lucky_ore_max_y;
    public final ForgeConfigSpec.ConfigValue<Integer> nether_lucky_ore_vein_count;
    public final ForgeConfigSpec.ConfigValue<Integer> nether_lucky_ore_vein_size;
    public final ForgeConfigSpec.ConfigValue<Integer> nether_lucky_ore_min_y;
    public final ForgeConfigSpec.ConfigValue<Integer> nether_lucky_ore_max_y;
    public final ForgeConfigSpec.ConfigValue<Integer> lucky_emerald_ore_increased_drops;
    public final ForgeConfigSpec.ConfigValue<Integer> lucky_lapis_ore_increased_drops;
    public final ForgeConfigSpec.ConfigValue<Integer> lucky_redstone_ore_increased_drops;
    public final ForgeConfigSpec.ConfigValue<Integer> general_increased_drops;
    public final ForgeConfigSpec.ConfigValue<Integer> lucky_diamond_ore_increased_drops;
    public final ForgeConfigSpec.ConfigValue<Double> zombie_dust_drop_chance;
    public final ForgeConfigSpec.ConfigValue<Double> zombie_dust_looting_multiplier;

    ClientConfig(ForgeConfigSpec.Builder builder) {
        builder.push("general");
        this.lucky_diamond_ore_enabled = builder.comment("The Lucky Diamond Ore is obtainable/enabled").translation("luckyoreconfig.lucky_diamond_ore").define("lucky_diamond_ore", true);
        this.lucky_emerald_ore_enabled = builder.comment("The Lucky Emerald Ore is obtainable/enabled").translation("luckyoreconfig.lucky_emerald_ore").define("lucky_emerald_ore", true);
        this.lucky_lapis_ore_enabled = builder.comment("The Lucky Lapis Lazuli Ore is obtainable/enabled").translation("luckyoreconfig.lucky_lapis_ore").define("lucky_lapis_ore", true);
        this.lucky_redstone_ore_enabled = builder.comment("The Lucky Redstone Ore is obtainable/enabled").translation("luckyoreconfig.lucky_redstone_ore").define("lucky_redstone_ore", true);
        this.nether_lucky_ore_enabled = builder.comment("Nether Lucky Ore is obtainable/enabled").translation("luckyoreconfig.lucky_diamond_ore").define("lucky_diamond_ore", true);
        this.zombie_dust_drop_chance = builder.comment("Chances for Rare Zombie Drops - see vanilla zombie.json loottable").translation("luckyoreconfig.zombie_dust_drop_chance").define("dust_drop_chance", (Object)0.025);
        this.zombie_dust_looting_multiplier = builder.comment("How far does looting affect the dust drop chances").translation("luckyoreconfig.zombie_dust_looting_multiplier").define("dust_looting_multiplier", (Object)0.01);
        builder.push("lucky_enchantment");
        this.lucky_enchantment_enabled = builder.comment("The Lucky Enchantment is obtainable/enabled").translation("luckyoreconfig.lucky_enchantment").define("lucky_enchantment", true);
        this.general_increased_drops = builder.comment("General amount of raw bonus drops gained from the Lucky Enchantment").translation("luckyoreconfig.general_increased_drops").define("general_inc_drops", (Object)0);
        this.lucky_emerald_ore_increased_drops = builder.comment("Specific amount of raw bonus drops gained from the Lucky Enchantment").translation("luckyoreconfig.lucky_emerald_ore_increased_drops").define("lucky_emerald_ore_inc_drops", (Object)3);
        this.lucky_lapis_ore_increased_drops = builder.define("lucky_lapis_ore_inc_drops", (Object)8);
        this.lucky_redstone_ore_increased_drops = builder.define("lucky_redstone_ore_increased_drops", (Object)6);
        this.lucky_diamond_ore_increased_drops = builder.define("lucky_diamond_ore_increased_drops", (Object)0);
        builder.pop(2);
        builder.push("worldgen");
        builder.push("lucky_ore");
        this.lucky_ore_vein_count = builder.comment("Configuration for Lucky Ore").translation("luckyoreconfig.lucky_ore_gen").define("vein_count", (Object)25);
        this.lucky_ore_vein_size = builder.define("vein_size", (Object)3);
        this.lucky_ore_min_y = builder.define("min_y", (Object)5);
        this.lucky_ore_max_y = builder.define("max_y", (Object)128);
        builder.pop();
        builder.push("nether_lucky ore");
        this.nether_lucky_ore_vein_count = builder.comment("Configuration for Nether Lucky Ore").translation("luckyoreconfig.lucky_ore_gen").define("vein_count", (Object)35);
        this.nether_lucky_ore_vein_size = builder.define("vein_size", (Object)3);
        this.nether_lucky_ore_min_y = builder.define("min_y", (Object)5);
        this.nether_lucky_ore_max_y = builder.comment("Warning the game will crash if the valuye is over 128. Vanilla can not generate Ores about 128").define("max_y", (Object)128);
    }
}

