/*
 * Decompiled with CFR 0.152.
 */
package drunkblood.luckyore.loot;

import com.google.gson.JsonObject;
import drunkblood.luckyore.config.LuckyOreConfig;
import drunkblood.luckyore.registries.ModBlocks;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class LuckyBonusModifier
extends LootModifier {
    protected LuckyBonusModifier(ILootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        ItemStack tool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
        Random random = context.func_216032_b();
        int increasedDrops = LuckyOreConfig.general_increased_drops;
        if (tool != null) {
            BlockState state = (BlockState)context.func_216031_c(LootParameters.field_216287_g);
            if (state != null) {
                if (((Block)ModBlocks.LUCKY_EMERALD_ORE.get()).func_176223_P().equals(state)) {
                    increasedDrops += LuckyOreConfig.lucky_emerald_ore_increased_drops;
                } else if (((Block)ModBlocks.LUCKY_LAPIS_ORE.get()).func_176223_P().equals(state)) {
                    increasedDrops += LuckyOreConfig.lucky_lapis_ore_increased_drops;
                } else if (((Block)ModBlocks.LUCKY_LAPIS_ORE.get()).func_176223_P().equals(state)) {
                    increasedDrops += LuckyOreConfig.lucky_redstone_ore_increased_drops;
                } else if (((Block)ModBlocks.LUCKY_DIAMOND_ORE.get()).func_176223_P().equals(state)) {
                    increasedDrops += LuckyOreConfig.lucky_diamond_ore_increased_drops;
                }
            }
            for (ItemStack stack : generatedLoot) {
                int bonus = 0;
                int cap = (int)(Math.log(increasedDrops * 4 + 1) / Math.log(2.0)) + 4;
                for (int i = 0; i < cap; ++i) {
                    if (!(random.nextFloat() < 0.75f)) continue;
                    ++bonus;
                }
                stack.func_190920_e(stack.func_190916_E() + increasedDrops + bonus);
            }
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<LuckyBonusModifier> {
        public LuckyBonusModifier read(ResourceLocation name, JsonObject object, ILootCondition[] conditionsIn) {
            return new LuckyBonusModifier(conditionsIn);
        }

        public JsonObject write(LuckyBonusModifier instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

