/*
 * Decompiled with CFR 0.152.
 */
package drunkblood.luckyore.loot;

import com.google.gson.JsonObject;
import drunkblood.luckyore.config.LuckyOreConfig;
import drunkblood.luckyore.registries.ModItems;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class ZombieDustModifier
extends LootModifier {
    protected ZombieDustModifier(ILootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        Entity entity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        if (entity instanceof ZombieEntity) {
            int i = context.getLootingModifier();
            if (context.func_216032_b().nextFloat() < LuckyOreConfig.zombie_dust_drop_chance + (float)i * LuckyOreConfig.zombie_dust_looting_multiplier) {
                generatedLoot.add(new ItemStack((IItemProvider)ModItems.LUCKY_DUST.get(), 1));
            }
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<ZombieDustModifier> {
        public ZombieDustModifier read(ResourceLocation name, JsonObject object, ILootCondition[] conditionsIn) {
            return new ZombieDustModifier(conditionsIn);
        }

        public JsonObject write(ZombieDustModifier instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

