/*
 * Decompiled with CFR 0.152.
 */
package drunkblood.luckyore;

import drunkblood.luckyore.block.BlockLuckyOre;
import drunkblood.luckyore.block.BlockNetherLuckyOre;
import drunkblood.luckyore.config.ConfigHelper;
import drunkblood.luckyore.config.ConfigHolder;
import drunkblood.luckyore.config.LuckyOreConfig;
import drunkblood.luckyore.enchantment.EnchantmentLucky;
import drunkblood.luckyore.loot.function.ApplyLuckyBonus;
import net.minecraft.block.Block;
import net.minecraft.block.RedstoneOreBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.TableLootEntry;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="luckyore")
public class LuckyOre {
    public static final String MODID = "luckyore";
    public static final String NAME = "Lucky Ore";
    public static final String VERSION = "1.2.2";
    public static final Logger LOGGER = LogManager.getLogger((String)"luckyore");

    public LuckyOre() {
        LOGGER.info("Hello from Example Mod!");
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, ConfigHolder.CLIENT_SPEC);
    }

    @ObjectHolder(value="luckyore")
    public static class ModEnchantments {
        public static final Enchantment ench_lucky = null;
    }

    @ObjectHolder(value="luckyore")
    public static class ModItems {
        public static final Item lucky_dust = null;
        public static final EnchantedBookItem book_lucky_ench = null;
    }

    @ObjectHolder(value="luckyore")
    public static class ModBlocks {
        public static final Block lucky_ore = null;
        public static final Block nether_lucky_ore = null;
        public static final Block lucky_diamond_ore = null;
        public static final Block lucky_redstone_ore = null;
        public static final Block lucky_lapis_ore = null;
        public static final Block lucky_emerald_ore = null;
    }

    @Mod.EventBusSubscriber(modid="luckyore", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static final class ForgeEventSubscriber {
        @SubscribeEvent
        public static void onLootTableLoad(LootTableLoadEvent event) {
            if (LuckyOreConfig.doZombieDrops && event.getName().equals((Object)new ResourceLocation("entities/zombie"))) {
                LOGGER.info("Adding lucky dust to Zombie");
                event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation(LuckyOre.MODID, "entities/zombie"))).func_216044_b());
            }
        }
    }

    @Mod.EventBusSubscriber(modid="luckyore", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static final class ModEventSubscriber {
        @SubscribeEvent
        public static void onRegisterItems(RegistryEvent.Register<Item> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{ModEventSubscriber.setup(new Item(new Item.Properties().func_200916_a(ItemGroup.field_78026_f)), "lucky_dust")});
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new BlockItem(ModBlocks.lucky_ore, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName(ModBlocks.lucky_ore.getRegistryName()), (Item)new BlockItem(ModBlocks.nether_lucky_ore, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName(ModBlocks.nether_lucky_ore.getRegistryName()), (Item)new BlockItem(ModBlocks.lucky_diamond_ore, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName(ModBlocks.lucky_diamond_ore.getRegistryName()), (Item)new BlockItem(ModBlocks.lucky_emerald_ore, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName(ModBlocks.lucky_emerald_ore.getRegistryName()), (Item)new BlockItem(ModBlocks.lucky_lapis_ore, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName(ModBlocks.lucky_lapis_ore.getRegistryName()), (Item)new BlockItem(ModBlocks.lucky_redstone_ore, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName(ModBlocks.lucky_redstone_ore.getRegistryName())});
        }

        @SubscribeEvent
        public static void onRegisterBlocks(RegistryEvent.Register<Block> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{ModEventSubscriber.setup(new BlockLuckyOre(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(3.0f, 3.0f)), "lucky_ore"), ModEventSubscriber.setup(new BlockNetherLuckyOre(Block.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151655_K).func_200948_a(3.0f, 3.0f)), "nether_lucky_ore"), ModEventSubscriber.setup(new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(3.0f, 3.0f).harvestLevel(2)), "lucky_diamond_ore"), ModEventSubscriber.setup(new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(3.0f, 3.0f).harvestLevel(2)), "lucky_emerald_ore"), ModEventSubscriber.setup(new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(3.0f, 3.0f).harvestLevel(1)), "lucky_lapis_ore"), (Block)ModEventSubscriber.setup(new RedstoneOreBlock(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200944_c().func_200951_a(9).func_200948_a(3.0f, 3.0f).harvestLevel(2)), "lucky_redstone_ore")});
        }

        @SubscribeEvent
        public static void onRegisterEnchantments(RegistryEvent.Register<Enchantment> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Enchantment[]{ModEventSubscriber.setup(new EnchantmentLucky(Enchantment.Rarity.RARE, EquipmentSlotType.MAINHAND), "ench_lucky")});
        }

        @SubscribeEvent
        public static void onModConfigEvent(ModConfig.ModConfigEvent event) {
            ModConfig config = event.getConfig();
            if (config.getSpec() == ConfigHolder.CLIENT_SPEC) {
                ConfigHelper.bakeClient(config);
            }
            LOGGER.info("config baked");
        }

        @SubscribeEvent
        public static void LoadComplete(FMLLoadCompleteEvent event) {
            LOGGER.debug("event fired");
            for (Biome biome : ForgeRegistries.BIOMES) {
                if (biome.func_201856_r() == Biome.Category.THEEND) continue;
                if (biome.func_201856_r() == Biome.Category.NETHER) {
                    if (!LuckyOreConfig.enableNetherLuckyOreGen) continue;
                    biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NETHERRACK, ModBlocks.nether_lucky_ore.func_176223_P(), 3)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(35, 5, 0, 256))));
                    continue;
                }
                if (!LuckyOreConfig.enableLuckyOreGen) continue;
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ModBlocks.lucky_ore.func_176223_P(), 3)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(25, 5, 0, 128))));
            }
            ApplyLuckyBonus.Serializer applyLuckyBonus = new ApplyLuckyBonus.Serializer();
            LootFunctionManager.func_186582_a((ILootFunction.Serializer)applyLuckyBonus);
        }

        public static <T extends IForgeRegistryEntry<T>> T setup(T entry, String name) {
            return ModEventSubscriber.setup(entry, new ResourceLocation(LuckyOre.MODID, name));
        }

        public static <T extends IForgeRegistryEntry<T>> T setup(T entry, ResourceLocation registryName) {
            entry.setRegistryName(registryName);
            return entry;
        }
    }
}

