/*
 * Decompiled with CFR 0.152.
 */
package drunkblood.luckyore.loot.function;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import drunkblood.luckyore.LuckyOre;
import java.util.Random;
import java.util.Set;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootFunction;
import net.minecraft.world.storage.loot.LootParameter;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.conditions.ILootCondition;

public class ApplyLuckyBonus
extends LootFunction {
    private int increasedDrops;

    private ApplyLuckyBonus(ILootCondition[] conditionsIn, int drops) {
        super(conditionsIn);
        this.increasedDrops = drops;
    }

    public Set<LootParameter<?>> func_215855_a() {
        return ImmutableSet.of((Object)LootParameters.field_216289_i);
    }

    public ItemStack func_215859_a(ItemStack stack, LootContext context) {
        ItemStack itemstack = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
        if (itemstack != null) {
            ListNBT nbttaglist = itemstack.func_77986_q();
            Random random = context.func_216032_b();
            boolean lucky = false;
            boolean fortune = false;
            int fortunelvl = 0;
            if (nbttaglist != null) {
                for (int i1 = 0; i1 < nbttaglist.size(); ++i1) {
                    String enchantmentID = nbttaglist.func_150305_b(i1).func_74779_i("id");
                    if (LuckyOre.ModEnchantments.ench_lucky != null && enchantmentID.equals(String.valueOf(LuckyOre.ModEnchantments.ench_lucky.getRegistryName()))) {
                        lucky = true;
                    }
                    if (!enchantmentID.equals(String.valueOf(Enchantments.field_185308_t.getRegistryName()))) continue;
                    fortune = true;
                    fortunelvl = nbttaglist.func_150305_b(i1).func_74765_d("lvl");
                }
            }
            int roll1 = this.increasedDrops + 3 + random.nextInt(5 + (fortune ? 2 * fortunelvl : 0));
            if (lucky) {
                int roll2 = this.increasedDrops + 3 + random.nextInt(5 + (fortune ? 2 * fortunelvl : 0));
                roll1 = Math.max(roll1, roll2);
            }
            stack.func_190920_e(roll1);
        }
        return stack;
    }

    public static LootFunction.Builder<?> build(int drops) {
        return ApplyLuckyBonus.func_215860_a(context -> new ApplyLuckyBonus((ILootCondition[])context, drops));
    }

    public static class Serializer
    extends LootFunction.Serializer<ApplyLuckyBonus> {
        public Serializer() {
            super(new ResourceLocation("luckyore", "apply_lucky_bonus"), ApplyLuckyBonus.class);
        }

        public void serialize(JsonObject object, ApplyLuckyBonus functionClazz, JsonSerializationContext serializationContext) {
            super.func_186532_a(object, (LootFunction)functionClazz, serializationContext);
            object.add("incdrops", serializationContext.serialize((Object)functionClazz.increasedDrops));
        }

        public ApplyLuckyBonus deserialize(JsonObject object, JsonDeserializationContext deserializationContext, ILootCondition[] conditionsIn) {
            int drops = JSONUtils.func_151203_m((JsonObject)object, (String)"incdrops");
            return new ApplyLuckyBonus(conditionsIn, drops);
        }
    }
}

