/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.magical_torches.handlers;

import de.geheimagentnr1.magical_torches.elements.capabilities.ModCapabilities;
import de.geheimagentnr1.magical_torches.elements.capabilities.chicken_egg_spawning.ChickenEggSpawningCapability;
import de.geheimagentnr1.magical_torches.elements.capabilities.spawn_blocking.SpawnBlockingCapability;
import de.geheimagentnr1.magical_torches.elements.capabilities_client.sound_muffling.SoundMufflingClientCapability;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventHandler {
    @SubscribeEvent
    public static void onWorldAttachCapabilityEvent(AttachCapabilitiesEvent<World> event) {
        event.addCapability(ChickenEggSpawningCapability.registry_name, (ICapabilityProvider)new ChickenEggSpawningCapability());
        event.addCapability(SpawnBlockingCapability.registry_name, (ICapabilityProvider)new SpawnBlockingCapability());
    }

    private static void blockSpawning(World world, EntityEvent event, Entity entity) {
        world.getCapability(ModCapabilities.SPAWN_BLOCKING).ifPresent(capability -> {
            if (capability.shouldBlockEntitySpawn(entity)) {
                event.setResult(Event.Result.DENY);
            }
        });
    }

    @SubscribeEvent
    public static void onCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getResult() == Event.Result.ALLOW || event.isSpawner()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof PlayerEntity) {
            return;
        }
        ForgeEventHandler.blockSpawning(entity.func_130014_f_(), (EntityEvent)event, entity);
    }

    @SubscribeEvent
    public static void handleEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (event.getResult() == Event.Result.ALLOW) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof PlayerEntity) {
            return;
        }
        World world = event.getWorld();
        world.getCapability(ModCapabilities.CHICKEN_EGG_SPAWNING).ifPresent(capability -> {
            if (capability.shouldBlockChickenEggSpawn(entity)) {
                event.setCanceled(true);
            }
        });
        if (!event.isCanceled()) {
            ForgeEventHandler.blockSpawning(world, (EntityEvent)event, entity);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void handlePlaySoundEvent(PlaySoundEvent event) {
        if (event.getResult() == Event.Result.ALLOW) {
            return;
        }
        ISound sound = event.getSound();
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null && SoundMufflingClientCapability.shouldMuffleSound(sound)) {
            event.setResultSound(null);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void handleLogoutEvent(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        SoundMufflingClientCapability.clear();
    }
}

