/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.render;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import slimeknights.mantle.client.model.inventory.ModelItem;

public class RenderingHelper {
    private static final int BACKGROUND_COLOR = -267386864;
    private static final int START_COLOR = 0x505000FF;
    private static final int END_COLOR = 1344798847;
    private static final int Z_INDEX = 400;

    public static boolean applyRotation(MatrixStack matrices, BlockState state) {
        if (state.func_235901_b_((Property)BlockStateProperties.field_208157_J)) {
            return RenderingHelper.applyRotation(matrices, (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J));
        }
        return false;
    }

    public static boolean applyRotation(MatrixStack matrices, Direction facing) {
        if (facing.func_176740_k().func_176722_c() && facing != Direction.SOUTH) {
            matrices.func_227860_a_();
            matrices.func_227861_a_(0.5, 0.0, 0.5);
            matrices.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f * (float)facing.func_176736_b()));
            matrices.func_227861_a_(-0.5, 0.0, -0.5);
            return true;
        }
        return false;
    }

    public static void renderItem(MatrixStack matrices, IRenderTypeBuffer buffer, ItemStack item, ModelItem modelItem, int light) {
        float y;
        if (modelItem.isHidden()) {
            return;
        }
        if (item.func_190926_b()) {
            return;
        }
        matrices.func_227860_a_();
        Vector3f center = modelItem.getCenterScaled();
        matrices.func_227861_a_((double)center.func_195899_a(), (double)center.func_195900_b(), (double)center.func_195902_c());
        float scale = modelItem.getSizeScaled();
        matrices.func_227862_a_(scale, scale, scale);
        float x = modelItem.getX();
        if (x != 0.0f) {
            matrices.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(x));
        }
        if ((y = modelItem.getY()) != 0.0f) {
            matrices.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(y));
        }
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(item, ItemCameraTransforms.TransformType.NONE, light, OverlayTexture.field_229196_a_, matrices, buffer);
        matrices.func_227865_b_();
    }

    @Deprecated
    public static void drawHoveringText(MatrixStack mStack, List<ITextComponent> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, FontRenderer font) {
        RenderingHelper.drawHoveringText(mStack, textLines, mouseX, mouseY, screenWidth, screenHeight, maxTextWidth, -267386864, 0x505000FF, 1344798847, font);
    }

    @Deprecated
    private static void drawHoveringText(MatrixStack mStack, List<ITextComponent> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, int backgroundColor, int borderColorStart, int borderColorEnd, FontRenderer font) {
        ArrayList<IReorderingProcessor> finalText;
        int n;
        if (textLines.isEmpty()) {
            return;
        }
        int tooltipWidth = 0;
        for (ITextProperties iTextProperties : textLines) {
            int width = font.func_238414_a_(iTextProperties);
            if (width <= tooltipWidth) continue;
            tooltipWidth = width;
        }
        boolean needsWrap = false;
        boolean bl = true;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipWidth) < 4) {
            tooltipWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        if (maxTextWidth > 0 && tooltipWidth > maxTextWidth) {
            tooltipWidth = maxTextWidth;
            needsWrap = true;
        }
        if (needsWrap) {
            int wrappedTooltipWidth = 0;
            ArrayList<IReorderingProcessor> wrappedTextLines = new ArrayList<IReorderingProcessor>();
            for (int i = 0; i < textLines.size(); ++i) {
                ITextProperties textLine = (ITextProperties)textLines.get(i);
                List wrappedLine = font.func_238425_b_(textLine, tooltipWidth);
                if (i == 0) {
                    n = wrappedLine.size();
                }
                for (IReorderingProcessor line : wrappedLine) {
                    int lineWidth = font.func_243245_a(line);
                    if (lineWidth > wrappedTooltipWidth) {
                        wrappedTooltipWidth = lineWidth;
                    }
                    wrappedTextLines.add(line);
                }
            }
            tooltipWidth = wrappedTooltipWidth;
            finalText = wrappedTextLines;
            tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipWidth : mouseX + 12;
        } else {
            finalText = Lists.transform(textLines, ITextComponent::func_241878_f);
        }
        int tooltipY = mouseY - 12;
        int tooltipHeight = 8;
        if (textLines.size() > 1) {
            tooltipHeight += (textLines.size() - 1) * 10;
            if (textLines.size() > n) {
                tooltipHeight += 2;
            }
        }
        if (tooltipY < 4) {
            tooltipY = 4;
        } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 4;
        }
        mStack.func_227860_a_();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        Matrix4f mat = mStack.func_227866_c_().func_227870_a_();
        RenderingHelper.fillGradient(mat, buffer, tooltipX - 3, tooltipY - 4, tooltipX + tooltipWidth + 3, tooltipY - 3, 400, backgroundColor, backgroundColor);
        RenderingHelper.fillGradient(mat, buffer, tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipWidth + 3, tooltipY + tooltipHeight + 4, 400, backgroundColor, backgroundColor);
        RenderingHelper.fillGradient(mat, buffer, tooltipX - 3, tooltipY - 3, tooltipX + tooltipWidth + 3, tooltipY + tooltipHeight + 3, 400, backgroundColor, backgroundColor);
        RenderingHelper.fillGradient(mat, buffer, tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, 400, backgroundColor, backgroundColor);
        RenderingHelper.fillGradient(mat, buffer, tooltipX + tooltipWidth + 3, tooltipY - 3, tooltipX + tooltipWidth + 4, tooltipY + tooltipHeight + 3, 400, backgroundColor, backgroundColor);
        RenderingHelper.fillGradient(mat, buffer, tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, 400, borderColorStart, borderColorEnd);
        RenderingHelper.fillGradient(mat, buffer, tooltipX + tooltipWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipWidth + 3, tooltipY + tooltipHeight + 3 - 1, 400, borderColorStart, borderColorEnd);
        RenderingHelper.fillGradient(mat, buffer, tooltipX - 3, tooltipY - 3, tooltipX + tooltipWidth + 3, tooltipY - 3 + 1, 400, borderColorStart, borderColorStart);
        RenderingHelper.fillGradient(mat, buffer, tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipWidth + 3, tooltipY + tooltipHeight + 3, 400, borderColorEnd, borderColorEnd);
        RenderSystem.enableDepthTest();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        buffer.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)buffer);
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
        IRenderTypeBuffer.Impl renderType = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        mStack.func_227861_a_(0.0, 0.0, 400.0);
        for (int line = 0; line < finalText.size(); ++line) {
            IReorderingProcessor processor = (IReorderingProcessor)finalText.get(line);
            if (processor != null) {
                font.func_238416_a_(processor, (float)tooltipX, (float)tooltipY, -1, true, mat, (IRenderTypeBuffer)renderType, false, 0, 0xF000F0);
            }
            if (line == 0) {
                tooltipY += 2;
            }
            tooltipY += 10;
        }
        renderType.func_228461_a_();
        mStack.func_227865_b_();
    }

    @Deprecated
    private static void fillGradient(Matrix4f matrix, BufferBuilder builder, int x1, int y1, int x2, int y2, int z, int colorA, int colorB) {
        float alphaA = (float)(colorA >> 24 & 0xFF) / 255.0f;
        float redA = (float)(colorA >> 16 & 0xFF) / 255.0f;
        float greenA = (float)(colorA >> 8 & 0xFF) / 255.0f;
        float blueA = (float)(colorA & 0xFF) / 255.0f;
        float alphaB = (float)(colorB >> 24 & 0xFF) / 255.0f;
        float redB = (float)(colorB >> 16 & 0xFF) / 255.0f;
        float greenB = (float)(colorB >> 8 & 0xFF) / 255.0f;
        float blueB = (float)(colorB & 0xFF) / 255.0f;
        builder.func_227888_a_(matrix, (float)x2, (float)y1, (float)z).func_227885_a_(redA, greenA, blueA, alphaA).func_181675_d();
        builder.func_227888_a_(matrix, (float)x1, (float)y1, (float)z).func_227885_a_(redA, greenA, blueA, alphaA).func_181675_d();
        builder.func_227888_a_(matrix, (float)x1, (float)y2, (float)z).func_227885_a_(redB, greenB, blueB, alphaB).func_181675_d();
        builder.func_227888_a_(matrix, (float)x2, (float)y2, (float)z).func_227885_a_(redB, greenB, blueB, alphaB).func_181675_d();
    }
}

