/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import slimeknights.mantle.client.model.util.DynamicBakedWrapper;
import slimeknights.mantle.client.model.util.ModelConfigurationWrapper;
import slimeknights.mantle.client.model.util.ModelHelper;
import slimeknights.mantle.client.model.util.ModelTextureIteratable;
import slimeknights.mantle.client.model.util.SimpleBlockModel;
import slimeknights.mantle.item.RetexturedBlockItem;
import slimeknights.mantle.util.RetexturedHelper;

public class RetexturedModel
implements IModelGeometry<RetexturedModel> {
    private final SimpleBlockModel model;
    private final Set<String> retextured;

    protected RetexturedModel(SimpleBlockModel model, Set<String> retextured) {
        this.model = model;
        this.retextured = retextured;
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.model.getTextures(owner, modelGetter, missingTextureErrors);
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform transform, ItemOverrideList overrides, ResourceLocation location) {
        IBakedModel baked = this.model.bakeModel(owner, transform, overrides, spriteGetter, location);
        return new BakedModel(baked, owner, this.model, transform, RetexturedModel.getAllRetextured(owner, this.model, this.retextured));
    }

    public static Set<String> getAllRetextured(IModelConfiguration owner, SimpleBlockModel model, Set<String> originalSet) {
        HashSet retextured = Sets.newHashSet(originalSet);
        for (Map textures : ModelTextureIteratable.of(owner, model)) {
            textures.forEach((name, either) -> either.ifRight(parent -> {
                if (retextured.contains(parent)) {
                    retextured.add(name);
                }
            }));
        }
        return ImmutableSet.copyOf((Collection)retextured);
    }

    private static class RetexturedOverride
    extends ItemOverrideList {
        private static final RetexturedOverride INSTANCE = new RetexturedOverride();

        private RetexturedOverride() {
        }

        @Nullable
        public IBakedModel func_239290_a_(IBakedModel originalModel, ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
            if (stack.func_190926_b() || !stack.func_77942_o()) {
                return originalModel;
            }
            Block block = RetexturedBlockItem.getTexture(stack);
            if (block == Blocks.field_150350_a) {
                return originalModel;
            }
            return ((BakedModel)originalModel).getCachedModel(block);
        }
    }

    public static class RetexturedConfiguration
    extends ModelConfigurationWrapper {
        private final Set<String> retextured;
        private final RenderMaterial texture;

        public RetexturedConfiguration(IModelConfiguration base, Set<String> retextured, ResourceLocation texture) {
            super(base);
            this.retextured = retextured;
            this.texture = ModelLoaderRegistry.blockMaterial((ResourceLocation)texture);
        }

        @Override
        public boolean isTexturePresent(String name) {
            if (this.retextured.contains(name)) {
                return !MissingTextureSprite.func_195675_b().equals((Object)this.texture.func_229313_b_());
            }
            return super.isTexturePresent(name);
        }

        @Override
        public RenderMaterial resolveTexture(String name) {
            if (this.retextured.contains(name)) {
                return this.texture;
            }
            return super.resolveTexture(name);
        }
    }

    public static class BakedModel
    extends DynamicBakedWrapper<IBakedModel> {
        private final Map<ResourceLocation, IBakedModel> cache = new HashMap<ResourceLocation, IBakedModel>();
        private final IModelConfiguration owner;
        private final SimpleBlockModel model;
        private final IModelTransform transform;
        private final Set<String> retextured;

        public BakedModel(IBakedModel baked, IModelConfiguration owner, SimpleBlockModel model, IModelTransform transform, Set<String> retextured) {
            super(baked);
            this.model = model;
            this.owner = owner;
            this.transform = transform;
            this.retextured = retextured;
        }

        private IBakedModel getRetexturedModel(ResourceLocation name) {
            return this.model.bakeDynamic(new RetexturedConfiguration(this.owner, this.retextured, name), this.transform);
        }

        private IBakedModel getCachedModel(Block block) {
            return this.cache.computeIfAbsent(ModelHelper.getParticleTexture(block), this::getRetexturedModel);
        }

        public TextureAtlasSprite getParticleTexture(IModelData data) {
            Block block;
            if (this.retextured.contains("particle") && (block = (Block)data.getData(RetexturedHelper.BLOCK_PROPERTY)) != null) {
                return this.getCachedModel(block).getParticleTexture(data);
            }
            return this.originalModel.getParticleTexture(data);
        }

        @Override
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, Random random, IModelData data) {
            Block block = (Block)data.getData(RetexturedHelper.BLOCK_PROPERTY);
            if (block == null) {
                return this.originalModel.getQuads(state, direction, random, data);
            }
            return this.getCachedModel(block).getQuads(state, direction, random, data);
        }

        public ItemOverrideList func_188617_f() {
            return RetexturedOverride.INSTANCE;
        }
    }

    public static class Loader
    implements IModelLoader<RetexturedModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public RetexturedModel read(JsonDeserializationContext context, JsonObject json) {
            SimpleBlockModel model = SimpleBlockModel.deserialize(context, json);
            Set<String> retextured = Loader.getRetextured(json);
            return new RetexturedModel(model, retextured);
        }

        public static Set<String> getRetextured(JsonObject json) {
            if (json.has("retextured")) {
                JsonElement retextured = json.get("retextured");
                if (retextured.isJsonArray()) {
                    JsonArray array = retextured.getAsJsonArray();
                    if (array.size() == 0) {
                        throw new JsonSyntaxException("Must have at least one texture in retextured");
                    }
                    ImmutableSet.Builder builder = ImmutableSet.builder();
                    for (int i = 0; i < array.size(); ++i) {
                        builder.add((Object)JSONUtils.func_151206_a((JsonElement)array.get(i), (String)("retextured[" + i + "]")));
                    }
                    return builder.build();
                }
                if (retextured.isJsonPrimitive()) {
                    return ImmutableSet.of((Object)retextured.getAsString());
                }
            }
            throw new JsonSyntaxException("Missing retextured, expected to find a String or a JsonArray");
        }
    }
}

