/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.config;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import slimeknights.mantle.config.CachedBoolean;
import slimeknights.mantle.config.CachedValue;

public class Config {
    private static final List<CachedValue<?>> CLIENT_VALUES = new ArrayList();
    public static final CachedBoolean EXTRA_HEART_RENDERER;
    private static final ForgeConfigSpec.Builder CLIENT_BUILDER;
    public static final ForgeConfigSpec CLIENT_SPEC;

    private static CachedBoolean client(Function<ForgeConfigSpec.Builder, ForgeConfigSpec.BooleanValue> function) {
        CachedBoolean cached = new CachedBoolean((ForgeConfigSpec.ConfigValue<Boolean>)((ForgeConfigSpec.ConfigValue)function.apply(CLIENT_BUILDER)));
        CLIENT_VALUES.add(cached);
        return cached;
    }

    public static void configChanged(ModConfig.ModConfigEvent configEvent) {
        ModConfig config = configEvent.getConfig();
        if (config.getModId().equals("mantle") && config.getSpec() == CLIENT_SPEC) {
            CLIENT_VALUES.forEach(CachedValue::invalidate);
        }
    }

    static {
        CLIENT_BUILDER = new ForgeConfigSpec.Builder();
        EXTRA_HEART_RENDERER = Config.client(builder -> builder.comment(new String[]{"If true, enables the Mantle heart renderer, which stacks hearts by changing the color instead of vertically stacking them.", "Mod authors: this config is not meant for compatibility with your heart renderer, cancel the RenderGameOverlayEvent.Pre event and our logic won't run"}).translation("config.mantle.extraHeartRenderer").define("extraHeartRenderer", true));
        CLIENT_SPEC = CLIENT_BUILDER.build();
    }
}

