/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.util.JsonHelper;

public abstract class FluidIngredient {
    public static final FluidIngredient EMPTY = new Empty();

    public abstract boolean test(Fluid var1);

    public abstract int getAmount(Fluid var1);

    public boolean test(FluidStack stack) {
        Fluid fluid = stack.getFluid();
        return stack.getAmount() >= this.getAmount(fluid) && this.test(stack.getFluid());
    }

    public abstract List<FluidStack> getFluids();

    public abstract JsonElement serialize();

    public void write(PacketBuffer buffer) {
        List<FluidStack> fluids = this.getFluids();
        buffer.writeInt(fluids.size());
        for (FluidStack stack : fluids) {
            buffer.func_180714_a(Objects.requireNonNull(stack.getFluid().getRegistryName()).toString());
            buffer.writeInt(stack.getAmount());
        }
    }

    public static FluidIngredient of(Fluid fluid, int amount) {
        return new FluidMatch(fluid, amount);
    }

    public static FluidIngredient of(FluidStack stack) {
        return FluidIngredient.of(stack.getFluid(), stack.getAmount());
    }

    public static FluidIngredient of(ITag<Fluid> fluid, int amount) {
        return new TagMatch(fluid, amount);
    }

    public static FluidIngredient of(FluidIngredient ... ingredients) {
        return new Compound(ingredients);
    }

    public static FluidIngredient deserialize(JsonObject parent, String name) {
        return FluidIngredient.deserialize(JsonHelper.getElement(parent, name), name);
    }

    public static FluidIngredient deserialize(JsonElement json, String name) {
        if (json.isJsonObject()) {
            return FluidIngredient.deserializeObject(json.getAsJsonObject());
        }
        if (json.isJsonArray()) {
            return Compound.deserialize(json.getAsJsonArray(), name);
        }
        throw new JsonSyntaxException("Fluid ingredient " + name + " must be either an object or array");
    }

    private static FluidIngredient deserializeObject(JsonObject json) {
        if (json.entrySet().isEmpty()) {
            return EMPTY;
        }
        if (json.has("name")) {
            if (json.has("tag")) {
                throw new JsonSyntaxException("An ingredient entry is either a tag or an fluid, not both");
            }
            return FluidMatch.deserialize(json);
        }
        if (json.has("tag")) {
            return TagMatch.deserialize(json);
        }
        throw new JsonSyntaxException("An ingredient entry needs either a tag or an fluid");
    }

    public static FluidIngredient read(PacketBuffer buffer) {
        int count = buffer.readInt();
        FluidIngredient[] ingredients = new FluidIngredient[count];
        for (int i = 0; i < count; ++i) {
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(buffer.func_150789_c(Short.MAX_VALUE)));
            if (fluid == null) {
                fluid = Fluids.field_204541_a;
            }
            int amount = buffer.readInt();
            ingredients[i] = FluidIngredient.of(fluid, amount);
        }
        if (count == 1) {
            return ingredients[0];
        }
        return FluidIngredient.of(ingredients);
    }

    private static class Compound
    extends FluidIngredient {
        private final List<FluidIngredient> ingredients;

        private Compound(FluidIngredient[] ingredients) {
            this.ingredients = Arrays.asList(ingredients);
        }

        @Override
        public boolean test(Fluid fluid) {
            return this.ingredients.stream().anyMatch(ingredient -> ingredient.test(fluid));
        }

        @Override
        public boolean test(FluidStack stack) {
            return this.ingredients.stream().anyMatch(ingredient -> ingredient.test(stack));
        }

        @Override
        public int getAmount(Fluid fluid) {
            return this.ingredients.stream().filter(ingredient -> ingredient.test(fluid)).mapToInt(ingredient -> ingredient.getAmount(fluid)).findFirst().orElse(0);
        }

        @Override
        public List<FluidStack> getFluids() {
            return this.ingredients.stream().flatMap(ingredient -> ingredient.getFluids().stream()).collect(Collectors.toList());
        }

        @Override
        public JsonElement serialize() {
            return (JsonElement)this.ingredients.stream().map(FluidIngredient::serialize).collect(JsonArray::new, JsonArray::add, JsonArray::addAll);
        }

        private static Compound deserialize(JsonArray array, String name) {
            int size = array.size();
            if (size == 0) {
                throw new JsonSyntaxException("Fluid array cannot be empty, at least one fluid must be defined");
            }
            FluidIngredient[] ingredients = new FluidIngredient[size];
            for (int i = 0; i < size; ++i) {
                ingredients[i] = FluidIngredient.deserializeObject(JSONUtils.func_151210_l((JsonElement)array.get(i), (String)(name + "[" + i + "]")));
            }
            return new Compound(ingredients);
        }
    }

    private static class TagMatch
    extends FluidIngredient {
        private final ITag<Fluid> tag;
        private final int amount;

        @Override
        public boolean test(Fluid fluid) {
            return this.tag.func_230235_a_((Object)fluid);
        }

        @Override
        public int getAmount(Fluid fluid) {
            return this.amount;
        }

        @Override
        public List<FluidStack> getFluids() {
            return this.tag.func_230236_b_().stream().map(fluid -> new FluidStack(fluid, this.amount)).collect(Collectors.toList());
        }

        @Override
        public JsonElement serialize() {
            JsonObject object = new JsonObject();
            object.addProperty("tag", TagCollectionManager.func_242178_a().func_241837_c().func_232975_b_(this.tag).toString());
            object.addProperty("amount", (Number)this.amount);
            return object;
        }

        private static TagMatch deserialize(JsonObject json) {
            String tagName = JSONUtils.func_151200_h((JsonObject)json, (String)"tag");
            ITag tag = TagCollectionManager.func_242178_a().func_241837_c().func_199910_a(new ResourceLocation(tagName));
            if (tag == null) {
                throw new JsonSyntaxException("Unknown fluid tag '" + tagName + "'");
            }
            int amount = JSONUtils.func_151203_m((JsonObject)json, (String)"amount");
            return new TagMatch((ITag<Fluid>)tag, amount);
        }

        private TagMatch(ITag<Fluid> tag, int amount) {
            this.tag = tag;
            this.amount = amount;
        }
    }

    private static class FluidMatch
    extends FluidIngredient {
        private final Fluid fluid;
        private final int amount;

        @Override
        public boolean test(Fluid fluid) {
            return fluid == this.fluid;
        }

        @Override
        public int getAmount(Fluid fluid) {
            return this.amount;
        }

        @Override
        public List<FluidStack> getFluids() {
            return Collections.singletonList(new FluidStack(this.fluid, this.amount));
        }

        @Override
        public JsonElement serialize() {
            JsonObject object = new JsonObject();
            object.addProperty("name", Objects.requireNonNull(this.fluid.getRegistryName()).toString());
            object.addProperty("amount", (Number)this.amount);
            return object;
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.writeInt(1);
            buffer.func_180714_a(Objects.requireNonNull(this.fluid.getRegistryName()).toString());
            buffer.writeInt(this.amount);
        }

        private static FluidMatch deserialize(JsonObject json) {
            String fluidName = JSONUtils.func_151200_h((JsonObject)json, (String)"name");
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidName));
            if (fluid == null || fluid == Fluids.field_204541_a) {
                throw new JsonSyntaxException("Unknown fluid '" + fluidName + "'");
            }
            int amount = JSONUtils.func_151203_m((JsonObject)json, (String)"amount");
            return new FluidMatch(fluid, amount);
        }

        private FluidMatch(Fluid fluid, int amount) {
            this.fluid = fluid;
            this.amount = amount;
        }
    }

    private static class Empty
    extends FluidIngredient {
        @Override
        public boolean test(Fluid fluid) {
            return fluid == Fluids.field_204541_a;
        }

        @Override
        public boolean test(FluidStack fluid) {
            return fluid.isEmpty();
        }

        @Override
        public int getAmount(Fluid fluid) {
            return 0;
        }

        @Override
        public List<FluidStack> getFluids() {
            return Collections.emptyList();
        }

        @Override
        public JsonElement serialize() {
            return new JsonObject();
        }

        private Empty() {
        }
    }
}

