/*
 * Decompiled with CFR 0.152.
 */
package thatpreston.mermod.integration.origins;

import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.factory.PowerFactory;
import io.github.apace100.origins.registry.ModComponents;
import io.github.apace100.origins.registry.ModRegistries;
import io.github.apace100.origins.util.SerializableData;
import io.github.apace100.origins.util.SerializableDataType;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.apache.commons.lang3.tuple.Triple;
import thatpreston.mermod.integration.origins.TailStylePower;

public class OriginsIntegration {
    private static final class_2960 MERLING_IDENTIFIER = new class_2960("origins", "merling");
    private static final class_2960 LAYER_IDENTIFIER = new class_2960("origins", "origin");
    private static final class_2960 FACTORY_IDENTIFIER = new class_2960("mermod", "tail_style");

    public static boolean hasFabulousFins(class_1657 player) {
        OriginComponent component = (OriginComponent)ModComponents.ORIGIN.get((Object)player);
        Origin origin = component.getOrigin(OriginLayers.getLayer((class_2960)LAYER_IDENTIFIER));
        if (origin != null && origin.getIdentifier().equals((Object)MERLING_IDENTIFIER)) {
            return true;
        }
        return OriginComponent.hasPower((class_1297)player, TailStylePower.class);
    }

    public static Triple<Float, Float, Float> getTailColor(class_1657 player) {
        List powers = ((OriginComponent)ModComponents.ORIGIN.get((Object)player)).getPowers(TailStylePower.class);
        if (powers.size() > 0) {
            float red = powers.stream().map(TailStylePower::getRed).reduce((a, b) -> Float.valueOf(a.floatValue() * b.floatValue())).get().floatValue();
            float green = powers.stream().map(TailStylePower::getGreen).reduce((a, b) -> Float.valueOf(a.floatValue() * b.floatValue())).get().floatValue();
            float blue = powers.stream().map(TailStylePower::getBlue).reduce((a, b) -> Float.valueOf(a.floatValue() * b.floatValue())).get().floatValue();
            return Triple.of((Object)Float.valueOf(red), (Object)Float.valueOf(green), (Object)Float.valueOf(blue));
        }
        return Triple.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f));
    }

    private static void registerPowerFactory() {
        PowerFactory serializer = new PowerFactory(FACTORY_IDENTIFIER, new SerializableData().add("red", SerializableDataType.FLOAT, (Object)Float.valueOf(1.0f)).add("green", SerializableDataType.FLOAT, (Object)Float.valueOf(1.0f)).add("blue", SerializableDataType.FLOAT, (Object)Float.valueOf(1.0f)), data -> (type, player) -> new TailStylePower((PowerType<?>)type, (class_1657)player, data.getFloat("red"), data.getFloat("green"), data.getFloat("blue"))).allowCondition();
        class_2378.method_10230((class_2378)ModRegistries.POWER_FACTORY, (class_2960)serializer.getSerializerId(), (Object)serializer);
    }

    public static void init() {
        OriginsIntegration.registerPowerFactory();
    }
}

