/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftearthmod.block;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeature;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftearthmod.MinecraftEarthModModElements;
import net.minecraftearthmod.item.RubyItem;
import net.minecraftearthmod.procedures.RubyOreFortuneProcedure;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ObjectHolder;

@MinecraftEarthModModElements.ModElement.Tag
public class RubyOreBlock
extends MinecraftEarthModModElements.ModElement {
    @ObjectHolder(value="minecraft_earth_mod:ruby_ore")
    public static final Block block = null;

    public RubyOreBlock(MinecraftEarthModModElements instance) {
        super(instance, 13);
    }

    @Override
    public void initElements() {
        this.elements.blocks.add(() -> new CustomBlock());
        this.elements.items.add(() -> (Item)new BlockItem(block, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName(block.getRegistryName()));
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)new OreFeature(OreFeatureConfig::func_214641_a){

                public boolean func_212245_a(IWorld world, ChunkGenerator generator, Random rand, BlockPos pos, OreFeatureConfig config) {
                    DimensionType dimensionType = world.func_201675_m().func_186058_p();
                    boolean dimensionCriteria = false;
                    if (dimensionType == DimensionType.field_223227_a_) {
                        dimensionCriteria = true;
                    }
                    if (!dimensionCriteria) {
                        return false;
                    }
                    return super.func_212245_a(world, generator, rand, pos, config);
                }
            }, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.create((String)"ruby_ore", (String)"ruby_ore", blockAt -> {
                boolean blockCriteria = false;
                if (blockAt.func_177230_c() == Blocks.field_150348_b.func_176223_P().func_177230_c()) {
                    blockCriteria = true;
                }
                return blockCriteria;
            }), block.func_176223_P(), 3), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(9, 0, 0, 32)));
        }
    }

    public static class CustomBlock
    extends Block {
        public CustomBlock() {
            super(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d).func_200948_a(3.0f, 3.0f).func_200951_a(0).harvestLevel(2).harvestTool(ToolType.PICKAXE));
            this.setRegistryName("ruby_ore");
        }

        @OnlyIn(value=Dist.CLIENT)
        public BlockRenderLayer func_180664_k() {
            return BlockRenderLayer.CUTOUT_MIPPED;
        }

        public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
            List dropsOriginal = super.func_220076_a(state, builder);
            if (!dropsOriginal.isEmpty()) {
                return dropsOriginal;
            }
            return Collections.singletonList(new ItemStack((IItemProvider)RubyItem.block, 1));
        }

        public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity entity, boolean willHarvest, IFluidState fluid) {
            boolean retval = super.removedByPlayer(state, world, pos, entity, willHarvest, fluid);
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            HashMap<String, Object> $_dependencies = new HashMap<String, Object>();
            $_dependencies.put("entity", entity);
            $_dependencies.put("x", x);
            $_dependencies.put("y", y);
            $_dependencies.put("z", z);
            $_dependencies.put("world", world);
            RubyOreFortuneProcedure.executeProcedure($_dependencies);
            return retval;
        }
    }
}

