/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftearthmod.entity;

import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelBox;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftearthmod.MinecraftEarthModModElements;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

@MinecraftEarthModModElements.ModElement.Tag
public class FurnaceGolemEntity
extends MinecraftEarthModModElements.ModElement {
    public static EntityType entity = null;

    public FurnaceGolemEntity(MinecraftEarthModModElements instance) {
        super(instance, 12);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
    }

    @Override
    public void initElements() {
        entity = (EntityType)EntityType.Builder.func_220322_a(CustomEntity::new, (EntityClassification)EntityClassification.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CustomEntity::new).func_220321_a(1.4f, 2.7f).func_206830_a("furnace_golem").setRegistryName("furnace_golem");
        this.elements.entities.add(() -> entity);
        this.elements.items.add(() -> (Item)new SpawnEggItem(entity, -9079435, -30184, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setRegistryName("furnace_golem"));
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            biome.func_76747_a(EntityClassification.CREATURE).add(new Biome.SpawnListEntry(entity, 3, 1, 1));
        }
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151577_b && world.func_201669_a(pos, 0) > 8);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(CustomEntity.class, renderManager -> new MobRenderer(renderManager, new Modelfurnacegolem(), 0.5f){

            protected ResourceLocation func_110775_a(Entity entity) {
                return new ResourceLocation("minecraft_earth_mod:textures/furnacegolem.png");
            }
        });
    }

    public static class Modelfurnacegolem
    extends EntityModel<Entity> {
        private final RendererModel body;
        private final RendererModel head;
        private final RendererModel right_arm;
        private final RendererModel left_arm;
        private final RendererModel right_leg;
        private final RendererModel left_leg;

        public Modelfurnacegolem() {
            this.field_78090_t = 128;
            this.field_78089_u = 128;
            this.body = new RendererModel((Model)this);
            this.body.func_78793_a(0.0f, -7.0f, 0.0f);
            this.body.field_78804_l.add(new ModelBox(this.body, 0, 40, -9.0f, -2.0f, -6.0f, 18, 12, 11, 0.0f, true));
            this.body.field_78804_l.add(new ModelBox(this.body, 0, 70, -4.5f, 10.0f, -3.0f, 9, 5, 6, 0.5f, true));
            this.head = new RendererModel((Model)this);
            this.head.func_78793_a(0.0f, -7.0f, -2.0f);
            this.head.field_78804_l.add(new ModelBox(this.head, 0, 0, -4.0f, -12.0f, -5.5f, 8, 10, 8, 0.0f, true));
            this.head.field_78804_l.add(new ModelBox(this.head, 24, 0, -1.0f, -5.0f, -7.5f, 2, 4, 2, 0.0f, true));
            this.right_arm = new RendererModel((Model)this);
            this.right_arm.func_78793_a(0.0f, -7.0f, 0.0f);
            this.right_arm.field_78804_l.add(new ModelBox(this.right_arm, 60, 21, 9.0f, -2.5f, -3.0f, 4, 30, 6, 0.0f, true));
            this.left_arm = new RendererModel((Model)this);
            this.left_arm.func_78793_a(0.0f, -7.0f, 0.0f);
            this.left_arm.field_78804_l.add(new ModelBox(this.left_arm, 60, 58, -13.0f, -2.5f, -3.0f, 4, 30, 6, 0.0f, true));
            this.right_leg = new RendererModel((Model)this);
            this.right_leg.func_78793_a(-5.0f, 11.0f, 0.0f);
            this.right_leg.field_78804_l.add(new ModelBox(this.right_leg, 37, 0, 6.5f, -3.0f, -3.0f, 6, 16, 5, 0.0f, true));
            this.left_leg = new RendererModel((Model)this);
            this.left_leg.func_78793_a(5.0f, 11.0f, 0.0f);
            this.left_leg.field_78804_l.add(new ModelBox(this.left_leg, 60, 0, -12.5f, -3.0f, -3.0f, 6, 16, 5, 0.0f, true));
        }

        public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
            this.body.func_78785_a(f5);
            this.head.func_78785_a(f5);
            this.right_arm.func_78785_a(f5);
            this.left_arm.func_78785_a(f5);
            this.right_leg.func_78785_a(f5);
            this.left_leg.func_78785_a(f5);
        }

        public void setRotationAngle(RendererModel modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        public void func_212844_a_(Entity e, float f, float f1, float f2, float f3, float f4, float f5) {
            super.func_212844_a_(e, f, f1, f2, f3, f4, f5);
            this.head.field_78796_g = f3 / 57.295776f;
            this.head.field_78795_f = f4 / 57.295776f;
            this.right_arm.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f + (float)Math.PI)) * f1;
            this.left_leg.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * -1.0f * f1;
            this.left_arm.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f)) * f1;
            this.right_leg.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * 1.0f * f1;
        }
    }

    public static class CustomEntity
    extends IronGolemEntity {
        public CustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            this((EntityType<CustomEntity>)entity, world);
        }

        public CustomEntity(EntityType<CustomEntity> type, World world) {
            super(type, world);
            this.field_70728_aV = 10;
            this.func_94061_f(false);
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[]{((Object)((Object)this)).getClass()}));
            this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.2, true));
            this.field_70714_bg.func_75776_a(3, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.9));
            this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(5, (Goal)new SwimGoal((MobEntity)this));
        }

        public CreatureAttribute func_70668_bt() {
            return CreatureAttribute.field_223222_a_;
        }

        protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
            super.func_213333_a(source, looting, recentlyHitIn);
        }

        public SoundEvent func_184639_G() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.iron_golem.step"));
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.iron_golem.hurt"));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.iron_golem.death"));
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (source == DamageSource.field_76379_h) {
                return false;
            }
            if (source == DamageSource.field_76369_e) {
                return false;
            }
            return super.func_70097_a(source, amount);
        }

        protected void func_110147_ax() {
            super.func_110147_ax();
            if (this.func_110148_a(SharedMonsterAttributes.field_111263_d) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111267_a) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_188791_g) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(3.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111264_e) == null) {
                this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
            }
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
        }
    }
}

