/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.mining_helmet;

import com.legacy.mining_helmet.MiningHelmetConfig;
import com.legacy.mining_helmet.MiningHelmetDelayedCall;
import com.legacy.mining_helmet.MiningHelmetMod;
import com.legacy.mining_helmet.MiningHelmetRegistry;
import com.legacy.mining_helmet.block.AirLightSourceBlock;
import com.legacy.mining_helmet.block.WaterLightSourceBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MiningHelmetEvents {
    private static final Map<World, Map<Entity, LocationData>> worldEntityLocationData = new ConcurrentHashMap<World, Map<Entity, LocationData>>();
    private static final Map<Item, LightSource> itemLightSources = new HashMap<Item, LightSource>();
    private static final List<BlockState> replaceableBlockStates = new ArrayList<BlockState>();
    private static final List<Block> lightSourceBlocks = new ArrayList<Block>();
    private static final List<EntityType<?>> untrackedEntities = new ArrayList();

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity().func_200600_R() == EntityType.field_200725_aD && MiningHelmetConfig.zombieHelmetSpawnChance > 0 && event.getEntity().func_226278_cu_() < (double)event.getWorld().func_181545_F() && (MiningHelmetConfig.zombieHelmetSpawnChance == 1 || MiningHelmetConfig.zombieHelmetSpawnChance > 1 && event.getWorld().func_201674_k().nextInt(MiningHelmetConfig.zombieHelmetSpawnChance) == 0)) {
            event.getEntity().func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)MiningHelmetRegistry.MINING_HELMET));
            event.getEntity().func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151035_b));
        }
    }

    @SubscribeEvent
    public static void parseTags(WorldEvent.Load event) {
        if (itemLightSources.size() == 0) {
            replaceableBlockStates.add(Blocks.field_150350_a.func_176223_P());
            replaceableBlockStates.add(Blocks.field_201941_jj.func_176223_P());
            replaceableBlockStates.add(Blocks.field_201940_ji.func_176223_P());
            replaceableBlockStates.add(Blocks.field_150355_j.func_176223_P());
            replaceableBlockStates.add(Fluids.field_204546_a.func_207207_a(8, false).func_206883_i());
            replaceableBlockStates.add(Fluids.field_204546_a.func_207207_a(8, true).func_206883_i());
            for (int i = 1; i <= 15; ++i) {
                replaceableBlockStates.add(((AirLightSourceBlock)MiningHelmetRegistry.LIGHT_AIR).getStateWithLightValue(i));
                replaceableBlockStates.add(((WaterLightSourceBlock)MiningHelmetRegistry.LIGHT_WATER).getStateWithLightValue(i));
            }
            lightSourceBlocks.addAll(BlockTags.func_199896_a().func_199910_a(new ResourceLocation("mining_helmet", "light_sources")).func_230236_b_());
            untrackedEntities.addAll(EntityTypeTags.func_219762_a().func_199910_a(new ResourceLocation("mining_helmet", "untracked_entities")).func_230236_b_());
            ArrayList airOnly = new ArrayList();
            ArrayList waterOnly = new ArrayList();
            waterOnly.addAll(ItemTags.func_199903_a().func_199910_a(new ResourceLocation("mining_helmet", "portable_light_water")).func_230236_b_());
            airOnly.addAll(ItemTags.func_199903_a().func_199910_a(new ResourceLocation("mining_helmet", "portable_light_air")).func_230236_b_());
            for (int lightValue = 1; lightValue <= 15; ++lightValue) {
                try {
                    for (Item item : ItemTags.func_199903_a().func_199910_a(new ResourceLocation("mining_helmet", "portable_light_" + lightValue)).func_230236_b_()) {
                        Medium restrictedMedium = Medium.NONE;
                        if (airOnly.contains(item)) {
                            restrictedMedium = Medium.WATER;
                        }
                        if (waterOnly.contains(item)) {
                            restrictedMedium = Medium.AIR;
                        }
                        itemLightSources.put(item, new LightSource(lightValue, restrictedMedium));
                    }
                    continue;
                }
                catch (Exception e) {
                    MiningHelmetMod.LOGGER.debug("There are no portable light sources with a light value of " + lightValue);
                }
            }
        }
    }

    @SubscribeEvent
    public static void resetEntityLocationData(WorldEvent.Unload event) {
        World world;
        if (event.getWorld() instanceof World && (world = (World)event.getWorld()) != null && worldEntityLocationData.containsKey(world)) {
            for (Map.Entry<Entity, LocationData> entry : worldEntityLocationData.get(world).entrySet()) {
                entry.getValue().reset();
            }
            worldEntityLocationData.replace(world, new ConcurrentHashMap());
        }
    }

    @SubscribeEvent
    public static void registerEntity(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        World world = event.getWorld();
        if (!worldEntityLocationData.containsKey(world)) {
            worldEntityLocationData.put(world, new ConcurrentHashMap());
        }
        if (untrackedEntities.contains(entity.func_200600_R()) || entity instanceof ItemEntity && !itemLightSources.containsKey(((ItemEntity)entity).func_92059_d().func_77973_b())) {
            return;
        }
        worldEntityLocationData.get(world).put(entity, new LocationData());
    }

    @SubscribeEvent
    public static void checkEntityLocationAndLightStatus(TickEvent.WorldTickEvent event) {
        World world = event.world;
        Map<Entity, LocationData> entityLocationData = worldEntityLocationData.get(world);
        if (entityLocationData != null) {
            Iterator<Map.Entry<Entity, LocationData>> entrySet = entityLocationData.entrySet().iterator();
            while (entrySet.hasNext()) {
                Map.Entry<Entity, LocationData> entry = entrySet.next();
                Entity entity = entry.getKey();
                LocationData data = entry.getValue();
                if (!entity.func_70089_S()) {
                    data.reset();
                    entrySet.remove();
                    continue;
                }
                int lightValue = MiningHelmetEvents.greatestLightSourceOnEntity(entity, world);
                if (lightValue != 0) {
                    BlockPos blockToLight = MiningHelmetEvents.getClosestReplaceableBlock(entity, world);
                    BlockState originalBlockState = world.func_180495_p(blockToLight);
                    BlockState newBlockState = MiningHelmetEvents.getLitBlockState(lightValue, originalBlockState);
                    if (lightSourceBlocks.contains(originalBlockState.func_177230_c())) {
                        data.add(blockToLight, () -> {
                            if (newBlockState.func_177230_c() instanceof AirLightSourceBlock) {
                                if (world.func_180495_p(blockToLight.func_177984_a()).func_177230_c() == Blocks.field_150350_a) {
                                    world.func_175656_a(blockToLight, Blocks.field_150350_a.func_176223_P());
                                } else {
                                    world.func_175656_a(blockToLight, Blocks.field_201941_jj.func_176223_P());
                                }
                            } else if (world.func_175623_d(blockToLight.func_177984_a())) {
                                world.func_175656_a(blockToLight, Blocks.field_150355_j.func_176223_P());
                            } else {
                                world.func_175656_a(blockToLight, Fluids.field_204546_a.func_207207_a(8, false).func_206883_i());
                            }
                        });
                    } else {
                        data.add(blockToLight, () -> world.func_175656_a(blockToLight, originalBlockState));
                    }
                    if (lightValue <= world.func_217298_h(blockToLight) && !(entity instanceof PlayerEntity)) continue;
                    world.func_175656_a(blockToLight, newBlockState);
                    continue;
                }
                data.reset();
            }
        }
    }

    private static int greatestLightSourceOnEntity(Entity entity, World world) {
        int lightValue = 0;
        if (!untrackedEntities.contains(entity.func_200600_R()) && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            Block blockToReplace = world.func_180495_p(MiningHelmetEvents.getClosestReplaceableBlock(entity, world)).func_177230_c();
            ItemStack handSlot = living.func_184614_ca();
            ItemStack offhandSlot = living.func_184592_cb();
            for (ItemStack itemStackheld : living.func_184214_aD()) {
                if (!itemLightSources.containsKey(itemStackheld.func_77973_b()) || offhandSlot.func_77973_b() == MiningHelmetRegistry.MINING_HELMET || handSlot.func_77973_b() == MiningHelmetRegistry.MINING_HELMET) continue;
                LightSource itemheld = itemLightSources.get(itemStackheld.func_77973_b());
                if (itemheld.lightValue <= lightValue || itemheld.restrictedMedium == MiningHelmetEvents.getMedium(blockToReplace)) continue;
                lightValue = itemheld.lightValue;
            }
            for (ItemStack itemStackequip : living.func_184193_aE()) {
                if (!itemLightSources.containsKey(itemStackequip.func_77973_b())) continue;
                LightSource itemequip = itemLightSources.get(itemStackequip.func_77973_b());
                if (itemequip.lightValue <= lightValue) continue;
                lightValue = itemequip.lightValue;
            }
        } else if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            Block blockToReplace = world.func_180495_p(MiningHelmetEvents.getClosestReplaceableBlock(entity, world)).func_177230_c();
            if (itemLightSources.containsKey(itemEntity.func_92059_d().func_77973_b())) {
                LightSource item = itemLightSources.get(itemEntity.func_92059_d().func_77973_b());
                if (item.lightValue > lightValue && item.restrictedMedium != MiningHelmetEvents.getMedium(blockToReplace)) {
                    lightValue = item.lightValue;
                }
            }
        }
        return lightValue;
    }

    private static Medium getMedium(Block blockToReplace) {
        if (blockToReplace == Blocks.field_201941_jj || blockToReplace == Blocks.field_150350_a || blockToReplace == MiningHelmetRegistry.LIGHT_AIR) {
            return Medium.AIR;
        }
        if (blockToReplace == Blocks.field_150355_j) {
            return Medium.WATER;
        }
        return Medium.VOID;
    }

    private static BlockPos getClosestReplaceableBlock(Entity entity, World world) {
        BlockPos position = entity.func_233580_cy_();
        if ((double)entity.func_213302_cg() > 1.2) {
            position = position.func_177982_a(0, 1, 0);
        }
        if (replaceableBlockStates.contains(world.func_180495_p(position))) {
            return position;
        }
        if (replaceableBlockStates.contains(world.func_180495_p(position.func_177984_a()))) {
            return position.func_177984_a();
        }
        if (replaceableBlockStates.contains(world.func_180495_p(position.func_177977_b()))) {
            return position.func_177977_b();
        }
        if (replaceableBlockStates.contains(world.func_180495_p(position.func_177974_f()))) {
            return position.func_177974_f();
        }
        if (replaceableBlockStates.contains(world.func_180495_p(position.func_177976_e()))) {
            return position.func_177976_e();
        }
        if (replaceableBlockStates.contains(world.func_180495_p(position.func_177978_c()))) {
            return position.func_177978_c();
        }
        if (replaceableBlockStates.contains(world.func_180495_p(position.func_177968_d()))) {
            return position.func_177968_d();
        }
        if (replaceableBlockStates.contains(world.func_180495_p(position.func_177984_a().func_177974_f()))) {
            return position.func_177984_a().func_177974_f();
        }
        if (replaceableBlockStates.contains(world.func_180495_p(position.func_177984_a().func_177976_e()))) {
            return position.func_177984_a().func_177976_e();
        }
        if (replaceableBlockStates.contains(world.func_180495_p(position.func_177984_a().func_177978_c()))) {
            return position.func_177984_a().func_177978_c();
        }
        if (replaceableBlockStates.contains(world.func_180495_p(position.func_177984_a().func_177968_d()))) {
            return position.func_177984_a().func_177968_d();
        }
        if (replaceableBlockStates.contains(world.func_180495_p(position.func_177977_b().func_177978_c()))) {
            return position.func_177977_b().func_177978_c();
        }
        if (replaceableBlockStates.contains(world.func_180495_p(position.func_177977_b().func_177974_f()))) {
            return position.func_177977_b().func_177974_f();
        }
        if (replaceableBlockStates.contains(world.func_180495_p(position.func_177977_b().func_177968_d()))) {
            return position.func_177977_b().func_177968_d();
        }
        if (replaceableBlockStates.contains(world.func_180495_p(position.func_177977_b().func_177976_e()))) {
            return position.func_177977_b().func_177976_e();
        }
        return position;
    }

    private static BlockState getLitBlockState(int lightValue, BlockState originalBlockState) {
        Block blockToReplace = originalBlockState.func_177230_c();
        if (blockToReplace == Blocks.field_201941_jj || blockToReplace == Blocks.field_150350_a || blockToReplace == MiningHelmetRegistry.LIGHT_AIR) {
            return ((AirLightSourceBlock)MiningHelmetRegistry.LIGHT_AIR).getStateWithLightValue(lightValue);
        }
        if (blockToReplace == Blocks.field_150355_j) {
            return ((WaterLightSourceBlock)MiningHelmetRegistry.LIGHT_WATER).getStateWithLightValue(lightValue);
        }
        return originalBlockState;
    }

    private static class LocationData {
        private final List<BlockData> litBlocks = new ArrayList<BlockData>();

        public void add(BlockPos position, MiningHelmetDelayedCall resetMethod) {
            switch (this.getDuplicateLocation(position)) {
                case FIRST: {
                    this.swapElements();
                    break;
                }
                case SECOND: {
                    break;
                }
                default: {
                    this.add(new BlockData(position, resetMethod));
                }
            }
        }

        private void swapElements() {
            if (this.litBlocks.size() > 1) {
                BlockData data = this.litBlocks.get(0);
                this.litBlocks.remove(0);
                this.litBlocks.add(data);
            }
        }

        private void add(BlockData data) {
            if (this.litBlocks.size() == 2) {
                this.removeFirstElement();
            }
            this.litBlocks.add(data);
        }

        private void removeFirstElement() {
            this.litBlocks.get((int)0).resetMethod.delayedCall();
            this.litBlocks.remove(0);
        }

        private DuplicateLocation getDuplicateLocation(BlockPos position) {
            if (this.litBlocks.size() == 2 && this.isDuplicate(position, this.litBlocks.get((int)0).position)) {
                return DuplicateLocation.FIRST;
            }
            if (this.litBlocks.size() > 1 && this.isDuplicate(position, this.litBlocks.get((int)1).position)) {
                return DuplicateLocation.SECOND;
            }
            return DuplicateLocation.NEITHER;
        }

        private boolean isDuplicate(BlockPos A, BlockPos B) {
            return A.func_177958_n() == B.func_177958_n() && A.func_177956_o() == B.func_177956_o() && A.func_177952_p() == B.func_177952_p();
        }

        public void reset() {
            for (BlockData data : this.litBlocks) {
                data.resetMethod.delayedCall();
            }
        }

        private static enum DuplicateLocation {
            FIRST,
            SECOND,
            NEITHER;

        }

        private static class BlockData {
            BlockPos position;
            MiningHelmetDelayedCall resetMethod;

            public BlockData(BlockPos position, MiningHelmetDelayedCall resetMethod) {
                this.position = position;
                this.resetMethod = resetMethod;
            }
        }
    }

    private static enum Medium {
        AIR,
        WATER,
        VOID,
        NONE;

    }

    private static class LightSource {
        int lightValue;
        Medium restrictedMedium;

        public LightSource(int lightValue, Medium restrictedMedium) {
            this.lightValue = lightValue;
            this.restrictedMedium = restrictedMedium;
        }
    }
}

