/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.augment;

import com.blakebr0.cucumber.helper.BlockHelper;
import com.blakebr0.cucumber.helper.ColorHelper;
import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalagriculture.api.tinkering.AugmentType;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class MiningAOEAugment
extends Augment {
    private final int range;

    public MiningAOEAugment(ResourceLocation id, int tier, int range) {
        super(id, tier, EnumSet.of(AugmentType.PICKAXE, AugmentType.AXE, AugmentType.SHOVEL), MiningAOEAugment.getColor(14024694, tier), MiningAOEAugment.getColor(965309, tier));
        this.range = range;
    }

    @Override
    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        BlockRayTraceResult trace;
        int side;
        World world = player.func_130014_f_();
        return !this.harvest(stack, this.range, world, pos, side = (trace = BlockHelper.rayTraceBlocks((World)world, (PlayerEntity)player)).func_216354_b().ordinal(), player);
    }

    private boolean harvest(ItemStack stack, int radius, World world, BlockPos pos, int side, PlayerEntity player) {
        if (player.func_213453_ef()) {
            radius = 0;
        }
        int xRange = radius;
        int yRange = radius;
        int zRange = 0;
        if (side == 0 || side == 1) {
            zRange = radius;
            yRange = 0;
        }
        if (side == 4 || side == 5) {
            xRange = 0;
            zRange = radius;
        }
        BlockState state = world.func_180495_p(pos);
        float hardness = state.func_185887_b((IBlockReader)world, pos);
        if (!this.tryHarvest(world, pos, false, stack, player)) {
            return false;
        }
        Block block = state.func_177230_c();
        if (radius > 0 && hardness >= 0.2f && block.getHarvestTool(state) == null || stack.getToolTypes().stream().anyMatch(t -> block.isToolEffective(state, t))) {
            BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-xRange, -yRange, -zRange), (BlockPos)pos.func_177982_a(xRange, yRange, zRange)).forEach(aoePos -> {
                BlockState aoeState;
                if (aoePos != pos && !(aoeState = world.func_180495_p(aoePos)).hasTileEntity() && aoeState.func_185887_b((IBlockReader)world, aoePos) <= hardness + 5.0f) {
                    Block aoeBlock = aoeState.func_177230_c();
                    if (block.getHarvestTool(state) == null || stack.getToolTypes().stream().anyMatch(t -> aoeBlock.isToolEffective(state, t))) {
                        this.tryHarvest(world, (BlockPos)aoePos, true, stack, player);
                    }
                }
            });
        }
        return true;
    }

    private boolean tryHarvest(World world, BlockPos pos, boolean extra, ItemStack stack, PlayerEntity player) {
        boolean harvest;
        BlockState state = world.func_180495_p(pos);
        float hardness = state.func_185887_b((IBlockReader)world, pos);
        Item item = stack.func_77973_b();
        boolean bl = harvest = !(!ForgeHooks.canHarvestBlock((BlockState)state, (PlayerEntity)player, (IBlockReader)world, (BlockPos)pos) && !item.canHarvestBlock(stack, state) || extra && !(item.func_150893_a(stack, world.func_180495_p(pos)) > 1.0f));
        if (hardness >= 0.0f && (!extra || harvest)) {
            return BlockHelper.breakBlocksAOE((ItemStack)stack, (World)world, (PlayerEntity)player, (BlockPos)pos);
        }
        return false;
    }

    private static int getColor(int color, int tier) {
        return ColorHelper.saturate((int)color, (float)Math.min((float)tier / 5.0f, 1.0f));
    }
}

