/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.item.armor;

import com.blakebr0.cucumber.item.BaseArmorItem;
import com.blakebr0.mysticalagriculture.api.tinkering.AugmentType;
import com.blakebr0.mysticalagriculture.api.tinkering.IAugment;
import com.blakebr0.mysticalagriculture.api.tinkering.ITinkerable;
import com.blakebr0.mysticalagriculture.api.util.AugmentUtils;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EssenceHelmetItem
extends BaseArmorItem
implements ITinkerable {
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    private static final EnumSet<AugmentType> TYPES = EnumSet.of(AugmentType.ARMOR, AugmentType.HELMET);
    private final int tinkerableTier;
    private final int slots;

    public EssenceHelmetItem(IArmorMaterial material, int tinkerableTier, int slots, Function<Item.Properties, Item.Properties> properties) {
        super(material, EquipmentSlotType.HEAD, properties);
        this.tinkerableTier = tinkerableTier;
        this.slots = slots;
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        AugmentUtils.getAugments(stack).forEach(a -> a.onArmorTick(stack, world, player));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(ModTooltips.getTooltipForTier(this.tinkerableTier));
        AugmentUtils.getAugments(stack).forEach(a -> tooltip.add((ITextComponent)a.getDisplayName().func_240699_a_(TextFormatting.GRAY)));
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        HashMultimap modifiers = HashMultimap.create();
        if (slot == this.func_185083_B_()) {
            IArmorMaterial material = this.func_200880_d();
            modifiers.put((Object)Attributes.field_233826_i_, (Object)new AttributeModifier(ARMOR_MODIFIERS[slot.func_188454_b()], "Armor modifier", (double)material.func_200902_b(slot), AttributeModifier.Operation.ADDITION));
            modifiers.put((Object)Attributes.field_233827_j_, (Object)new AttributeModifier(ARMOR_MODIFIERS[slot.func_188454_b()], "Armor toughness", (double)material.func_200901_e(), AttributeModifier.Operation.ADDITION));
            if (material.func_230304_f_() > 0.0f) {
                modifiers.put((Object)Attributes.field_233820_c_, (Object)new AttributeModifier(ARMOR_MODIFIERS[slot.func_188454_b()], "Armor knockback resistance", (double)material.func_230304_f_(), AttributeModifier.Operation.ADDITION));
            }
            AugmentUtils.getAugments(stack).forEach(arg_0 -> EssenceHelmetItem.lambda$getAttributeModifiers$2((Multimap)modifiers, slot, stack, arg_0));
        }
        return modifiers;
    }

    @Override
    public int getAugmentSlots() {
        return this.slots;
    }

    @Override
    public EnumSet<AugmentType> getAugmentTypes() {
        return TYPES;
    }

    @Override
    public int getTinkerableTier() {
        return this.tinkerableTier;
    }

    private static /* synthetic */ void lambda$getAttributeModifiers$2(Multimap modifiers, EquipmentSlotType slot, ItemStack stack, IAugment a) {
        a.addArmorAttributeModifiers((Multimap<Attribute, AttributeModifier>)modifiers, slot, stack);
    }
}

