/*
 * Decompiled with CFR 0.152.
 */
package com.github.wimpingego.nnow.objects.blocks.slabs;

import com.github.wimpingego.nnow.init.BlockList;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SlabBlock;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="nnow", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class PathSlab
extends SlabBlock
implements IWaterLoggable {
    private static final VoxelShape BOTTOM_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape TOP_SHAPE = Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private static final VoxelShape DOUBLE_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public PathSlab() {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_185774_da));
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{SlabBlock.field_196505_a, WATERLOGGED});
    }

    public boolean func_220074_n(BlockState state) {
        return state.func_177229_b((Property)SlabBlock.field_196505_a) != SlabType.DOUBLE;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        SlabType slabtype = (SlabType)state.func_177229_b((Property)SlabBlock.field_196505_a);
        switch (slabtype) {
            case DOUBLE: {
                return DOUBLE_SHAPE;
            }
            case TOP: {
                return TOP_SHAPE;
            }
        }
        return BOTTOM_SHAPE;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        BlockState blockstate = context.func_195991_k().func_180495_p(blockpos);
        Object slabtype = null;
        if (blockstate.func_177230_c() == this || slabtype == SlabType.BOTTOM && (blockstate.func_177230_c() == BlockList.DIRT_SLAB.get() || blockstate.func_177230_c() == BlockList.GRASS_SLAB.get() || blockstate.func_177230_c() == BlockList.COARSEDIRT_SLAB.get())) {
            return Blocks.field_185774_da.func_176223_P();
        }
        if (slabtype == SlabType.TOP && blockstate.func_177230_c() == BlockList.DIRT_SLAB.get()) {
            return Blocks.field_150346_d.func_176223_P();
        }
        if (slabtype == SlabType.TOP && blockstate.func_177230_c() == BlockList.GRASS_SLAB.get()) {
            return Blocks.field_196658_i.func_176223_P();
        }
        if (slabtype == SlabType.TOP && blockstate.func_177230_c() == BlockList.COARSEDIRT_SLAB.get()) {
            return Blocks.field_196660_k.func_176223_P();
        }
        FluidState ifluidstate = context.func_195991_k().func_204610_c(blockpos);
        BlockState blockstate1 = (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
        Direction direction = context.func_196000_l();
        return !(direction == Direction.DOWN || direction != Direction.UP && context.func_221532_j().field_72448_b - (double)blockpos.func_177956_o() > 0.5) ? blockstate1 : (BlockState)blockstate1.func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.TOP);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockState blockstate = worldIn.func_180495_p(pos.func_177984_a());
        return !blockstate.func_185904_a().func_76220_a() || blockstate.func_177230_c() instanceof FenceGateBlock;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_229870_f_(BlockState p_229870_1_, IBlockReader p_229870_2_, BlockPos p_229870_3_) {
        return true;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.UP && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }
}

