/*
 * Decompiled with CFR 0.152.
 */
package com.github.wimpingego.nnow.objects.blocks.traps;

import com.github.wimpingego.nnow.objects.blocks.traps.TrapDamageSource;
import com.github.wimpingego.nnow.objects.blocks.traps.TrapType;
import com.github.wimpingego.nnow.util.NNOWFakePlayer;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class TrapBaseBlock
extends Block {
    public static final VoxelShape NORTH_SHAPE = TrapBaseBlock.func_208617_a((double)0.8, (double)0.8, (double)0.0, (double)15.2, (double)15.2, (double)4.0);
    public static final VoxelShape WEST_SHAPE = TrapBaseBlock.func_208617_a((double)0.0, (double)0.8, (double)0.8, (double)4.0, (double)15.2, (double)15.2);
    public static final VoxelShape SOUTH_SHAPE = TrapBaseBlock.func_208617_a((double)0.8, (double)0.8, (double)12.0, (double)15.2, (double)15.2, (double)16.0);
    public static final VoxelShape EAST_SHAPE = TrapBaseBlock.func_208617_a((double)12.0, (double)0.8, (double)0.8, (double)16.0, (double)15.2, (double)15.2);
    public static final VoxelShape UP_SHAPE = TrapBaseBlock.func_208617_a((double)0.8, (double)0.0, (double)0.8, (double)15.2, (double)4.0, (double)15.2);
    public static final VoxelShape DOWN_SHAPE = TrapBaseBlock.func_208617_a((double)0.8, (double)12.0, (double)1.6, (double)14.4, (double)16.0, (double)14.4);
    public static final DirectionProperty NORTH = DirectionalBlock.field_176387_N;
    public static final DirectionProperty EAST = DirectionalBlock.field_176387_N;
    public static final DirectionProperty SOUTH = DirectionalBlock.field_176387_N;
    public static final DirectionProperty WEST = DirectionalBlock.field_176387_N;
    public static final DirectionProperty UP = DirectionalBlock.field_176387_N;
    public static final DirectionProperty DOWN = DirectionalBlock.field_176387_N;
    private final TrapType type;

    public TrapBaseBlock(AbstractBlock.Properties properties, TrapType type) {
        super(properties);
        this.type = type;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)NORTH, (Comparable)context.func_196010_d().func_176734_d());
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation direction) {
        return (BlockState)state.func_206870_a((Property)NORTH, (Comparable)direction.func_185831_a((Direction)state.func_177229_b((Property)SOUTH)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{NORTH});
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof LivingEntity && entityIn.func_200600_R() != EntityType.field_200729_aH && entityIn.func_200600_R() != EntityType.field_200756_av && !worldIn.field_72995_K && entityIn instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entityIn;
            if (this.type.lethal || livingEntity.func_110143_aJ() > 1.0f) {
                NNOWFakePlayer fakePlayer;
                TrapDamageSource spikeDmgSource = new TrapDamageSource(this.type);
                if (this.type.isPlayer && (fakePlayer = (NNOWFakePlayer)((Object)NNOWFakePlayer.getInstance((ServerWorld)worldIn).get())) != null) {
                    spikeDmgSource.setSource((Entity)fakePlayer);
                }
                livingEntity.func_70097_a((DamageSource)spikeDmgSource, this.type.damage);
            }
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H)) {
            case DOWN: {
                return DOWN_SHAPE;
            }
            case EAST: {
                return WEST_SHAPE;
            }
            case NORTH: {
                return SOUTH_SHAPE;
            }
            case SOUTH: {
                return NORTH_SHAPE;
            }
            case UP: {
                return UP_SHAPE;
            }
            case WEST: {
                return EAST_SHAPE;
            }
        }
        return NORTH_SHAPE;
    }
}

