/*
 * Decompiled with CFR 0.152.
 */
package com.github.wimpingego.nnow.util;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ModConfigs {
    public static final ForgeConfigSpec ALL;
    public static final Bookshelf BOOKSHELF;
    public static final Viagre VIAGRE;
    public static final Magnet MAGNET;
    public static final Poking_Stick POKING_STICK;
    public static final General GENERAL;
    public static final Traps TRAPS;
    public static final CobbleGens COBBLEGEN;
    public static final Tools TOOLS;
    public static final Berrys BERRYS;
    public static ForgeConfigSpec.IntValue PICKUP_RANGE;
    public static ForgeConfigSpec.IntValue VIAGRA_RADIUS;
    public static ForgeConfigSpec.IntValue VIAGRA_TICK_DELAY;
    public static ForgeConfigSpec.ConfigValue<Integer> VIAGRA_MAX_USES;
    public static ForgeConfigSpec.BooleanValue VIAGRA_TAKES_USES;
    public static ForgeConfigSpec.BooleanValue METALS_ITEMS_LOADED;
    public static ForgeConfigSpec.IntValue ENCHANT_POWER;
    public static ForgeConfigSpec.ConfigValue<Integer> BASE_MAX_USES;
    public static ForgeConfigSpec.ConfigValue<Integer> STONE_MAX_USES;
    public static ForgeConfigSpec.ConfigValue<Integer> IRON_MAX_USES;
    public static ForgeConfigSpec.DoubleValue SAPLING_DROP_CHANCE;
    public static ForgeConfigSpec.DoubleValue CACTUS_DROP_CHANCE;
    public static ForgeConfigSpec.ConfigValue<Integer> XP_POINTS;
    public static ForgeConfigSpec.ConfigValue<Integer> COAL_NUGGETS;
    public static ForgeConfigSpec.ConfigValue<Integer> GOLD_NUGGETS;
    public static ForgeConfigSpec.ConfigValue<Integer> IRON_NUGGETS;
    public static ForgeConfigSpec.ConfigValue<Integer> LAPIS_NUGGETS;
    public static ForgeConfigSpec.ConfigValue<Integer> QUARTZ_NUGGETS;
    public static ForgeConfigSpec.ConfigValue<Integer> REDSTONE_NUGGETS;
    public static ForgeConfigSpec.ConfigValue<Integer> DIAMOND_NUGGETS;
    public static ForgeConfigSpec.ConfigValue<Integer> EMERALD_NUGGETS;
    public static ForgeConfigSpec.ConfigValue<Integer> NETHERITE_NUGGETS;
    public static ForgeConfigSpec.ConfigValue<Integer> ICE_NUGGETS;
    public static ForgeConfigSpec.ConfigValue<Integer> FIRE_NUGGETS;
    public static ForgeConfigSpec.ConfigValue<Integer> WOODEN_NUGGETS;
    public static ForgeConfigSpec.ConfigValue<Integer> STONE_DUST;
    public static ForgeConfigSpec.ConfigValue<Integer> SAND_DUST;
    public static ForgeConfigSpec.ConfigValue<Integer> CLAY_BALL;
    public static ForgeConfigSpec.ConfigValue<Integer> DIRT_DUST;
    public static ForgeConfigSpec.ConfigValue<Integer> GRAVEL_DUST;
    public static ForgeConfigSpec.ConfigValue<Integer> COPPER_NUGGETS;
    public static ForgeConfigSpec.ConfigValue<Integer> NICKEL_NUGGETS;
    public static ForgeConfigSpec.ConfigValue<Integer> SILVER_NUGGETS;
    public static ForgeConfigSpec.ConfigValue<Integer> URANIUM_NUGGETS;
    public static ForgeConfigSpec.ConfigValue<Integer> LEAD_NUGGETS;
    public static ForgeConfigSpec.ConfigValue<Integer> ALUMINUM_NUGGETS;
    public static ForgeConfigSpec.ConfigValue<Integer> TIN_NUGGETS;
    public static ForgeConfigSpec.ConfigValue<Integer> OSMIUM_NUGGETS;
    public static ForgeConfigSpec.ConfigValue<Integer> BISMUTH_NUGGETS;
    public static ForgeConfigSpec.ConfigValue<Integer> ZINC_NUGGETS;
    public static ForgeConfigSpec.ConfigValue<Integer> PLATINUM_NUGGETS;
    public static ForgeConfigSpec.ConfigValue<Integer> IRIDIUM_NUGGETS;
    public static ForgeConfigSpec.BooleanValue BERRY_DO_DAMAGE;
    public static ForgeConfigSpec.ConfigValue<Integer> BERRY_DAMAGE;
    public static ForgeConfigSpec.ConfigValue<Integer> W_COST;
    public static ForgeConfigSpec.ConfigValue<Integer> W_RETURN;
    public static ForgeConfigSpec.ConfigValue<Integer> S_COST;
    public static ForgeConfigSpec.ConfigValue<Integer> S_RETURN;
    public static ForgeConfigSpec.ConfigValue<Integer> I_COST;
    public static ForgeConfigSpec.ConfigValue<Integer> I_RETURN;
    public static ForgeConfigSpec.ConfigValue<Integer> G_COST;
    public static ForgeConfigSpec.ConfigValue<Integer> G_RETURN;
    public static ForgeConfigSpec.ConfigValue<Integer> D_COST;
    public static ForgeConfigSpec.ConfigValue<Integer> D_RETURN;
    public static ForgeConfigSpec.ConfigValue<Integer> N_COST;
    public static ForgeConfigSpec.ConfigValue<Integer> N_RETURN;
    public static ForgeConfigSpec.ConfigValue<Integer> E_COST;
    public static ForgeConfigSpec.ConfigValue<Integer> E_RETURN;
    public static ForgeConfigSpec.BooleanValue GIVEONLOGIN;
    public static ForgeConfigSpec.DoubleValue STONE_TIER_TOOL_SPEED_MODIFIER;
    public static ForgeConfigSpec.DoubleValue IRON_TIER_TOOL_SPEED_MODIFIER;
    public static ForgeConfigSpec.DoubleValue GOLDEN_TIER_TOOL_SPEED_MODIFIER;
    public static ForgeConfigSpec.DoubleValue DIAMOND_TIER_TOOL_SPEED_MODIFIER;
    public static ForgeConfigSpec.DoubleValue NETHERITE_TIER_TOOL_SPEED_MODIFIER;
    public static ForgeConfigSpec.DoubleValue EMERALD_TIER_TOOL_SPEED_MODIFIER;
    public static ForgeConfigSpec.ConfigValue<Integer> STONE_TIER_TOOL_DURABILITY_MODIFIER;
    public static ForgeConfigSpec.ConfigValue<Integer> IRON_TIER_TOOL_DURABILITY_MODIFIER;
    public static ForgeConfigSpec.ConfigValue<Integer> GOLDEN_TIER_TOOL_DURABILITY_MODIFIER;
    public static ForgeConfigSpec.ConfigValue<Integer> DIAMOND_TIER_TOOL_DURABILITY_MODIFIER;
    public static ForgeConfigSpec.ConfigValue<Integer> NETHERITE_TIER_TOOL_DURABILITY_MODIFIER;
    public static ForgeConfigSpec.ConfigValue<Integer> EMERALD_TIER_TOOL_DURABILITY_MODIFIER;
    public static ForgeConfigSpec.ConfigValue<Integer> GOLDERN_ATTACK_POWER;
    public static ForgeConfigSpec.ConfigValue<Integer> DIAMOND_ATTACK_POWER;
    public static ForgeConfigSpec.ConfigValue<Integer> WITHER_ATTACK_POWER;

    public static void load(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        BOOKSHELF = new Bookshelf(builder);
        VIAGRE = new Viagre(builder);
        MAGNET = new Magnet(builder);
        POKING_STICK = new Poking_Stick(builder);
        GENERAL = new General(builder);
        TRAPS = new Traps(builder);
        COBBLEGEN = new CobbleGens(builder);
        TOOLS = new Tools(builder);
        BERRYS = new Berrys(builder);
        ALL = builder.build();
    }

    private static class Berrys {
        Berrys(ForgeConfigSpec.Builder builder) {
            builder.comment("Configuration related to the Berry Bushes in world drops").push("Berrys");
            builder.comment(new String[0]).push("Damage Settings");
            BERRY_DO_DAMAGE = builder.comment(new String[0]).define("Berry Bushes do damage", true);
            BERRY_DAMAGE = builder.comment(new String[0]).define("Berry Bushes attack power modifier", (Object)1);
            builder.pop();
            builder.comment(new String[0]).push("Dusts");
            STONE_DUST = builder.comment(new String[0]).define("Stone dust", (Object)8);
            GRAVEL_DUST = builder.comment(new String[0]).define("Gravel dust", (Object)8);
            SAND_DUST = builder.comment(new String[0]).define("Sand dust", (Object)8);
            DIRT_DUST = builder.comment(new String[0]).define("Dirt dust", (Object)8);
            CLAY_BALL = builder.comment(new String[0]).define("Clay balls", (Object)8);
            builder.pop();
            builder.comment(new String[0]).push("Nuggets");
            ICE_NUGGETS = builder.comment(new String[0]).define("Ice Nuggets", (Object)2);
            FIRE_NUGGETS = builder.comment(new String[0]).define("Fire Nuggets", (Object)2);
            WOODEN_NUGGETS = builder.comment(new String[0]).define("Wooden Nuggets", (Object)16);
            COAL_NUGGETS = builder.comment(new String[0]).define("Coal Nuggets", (Object)2);
            IRON_NUGGETS = builder.comment(new String[0]).define("Iron Nuggets", (Object)2);
            GOLD_NUGGETS = builder.comment(new String[0]).define("Gold Nuggets", (Object)2);
            REDSTONE_NUGGETS = builder.comment(new String[0]).define("Redstone Nuggets", (Object)2);
            LAPIS_NUGGETS = builder.comment(new String[0]).define("Lapis Nuggets", (Object)2);
            QUARTZ_NUGGETS = builder.comment(new String[0]).define("Quartz Nuggets", (Object)2);
            DIAMOND_NUGGETS = builder.comment(new String[0]).define("Diamond Nuggets", (Object)2);
            NETHERITE_NUGGETS = builder.comment(new String[0]).define("Netherite Nuggets", (Object)2);
            EMERALD_NUGGETS = builder.comment(new String[0]).define("Emerald Nuggets", (Object)2);
            XP_POINTS = builder.comment(new String[0]).define("XP Orbs", (Object)64);
            builder.pop();
            builder.comment(new String[0]).push("Metal Berrys Bush Nuggets");
            COPPER_NUGGETS = builder.comment(new String[0]).define("Copper Nuggets", (Object)2);
            NICKEL_NUGGETS = builder.comment(new String[0]).define("Nickel Nuggets", (Object)2);
            SILVER_NUGGETS = builder.comment(new String[0]).define("Sliver Nuggets", (Object)2);
            URANIUM_NUGGETS = builder.comment(new String[0]).define("Uranium Nuggets", (Object)2);
            LEAD_NUGGETS = builder.comment(new String[0]).define("Lead Nuggets", (Object)2);
            ALUMINUM_NUGGETS = builder.comment(new String[0]).define("Aluminum Nuggets", (Object)2);
            TIN_NUGGETS = builder.comment(new String[0]).define("Tin Nuggets", (Object)2);
            OSMIUM_NUGGETS = builder.comment(new String[0]).define("Osmium Nuggets", (Object)2);
            BISMUTH_NUGGETS = builder.comment(new String[0]).define("Bismuth Nuggets", (Object)2);
            ZINC_NUGGETS = builder.comment(new String[0]).define("Zinc Nuggets", (Object)2);
            PLATINUM_NUGGETS = builder.comment(new String[0]).define("Platinum Nuggets", (Object)2);
            IRIDIUM_NUGGETS = builder.comment(new String[0]).define("Iridium Nuggets", (Object)2);
            builder.pop();
            builder.pop();
        }
    }

    private static class Tools {
        Tools(ForgeConfigSpec.Builder builder) {
            builder.comment("Configuration related to the 3x3 mining tools").push("3x3 Tools");
            builder.comment("Tier speed modifier").push("Speed");
            STONE_TIER_TOOL_SPEED_MODIFIER = builder.comment(new String[0]).defineInRange("Stone Tier speed modifier", 4.5, 1.0, 10.0);
            IRON_TIER_TOOL_SPEED_MODIFIER = builder.comment(new String[0]).defineInRange("Iron Tier speed modifier", 3.5, 1.0, 10.0);
            GOLDEN_TIER_TOOL_SPEED_MODIFIER = builder.comment(new String[0]).defineInRange("Golden Tier speed modifier", 2.0, 1.0, 10.0);
            DIAMOND_TIER_TOOL_SPEED_MODIFIER = builder.comment(new String[0]).defineInRange("Diamond Tier speed modifier", 2.0, 1.0, 10.0);
            NETHERITE_TIER_TOOL_SPEED_MODIFIER = builder.comment(new String[0]).defineInRange("Netherite Tier speed modifier", 1.0, 1.0, 10.0);
            EMERALD_TIER_TOOL_SPEED_MODIFIER = builder.comment(new String[0]).defineInRange("Emerald Tier speed modifier", 2.0, 1.0, 10.0);
            builder.pop();
            builder.comment("Tier durability modifier").push("Durability");
            STONE_TIER_TOOL_DURABILITY_MODIFIER = builder.comment(new String[0]).define("Stone Tier durability modifier", (Object)197);
            IRON_TIER_TOOL_DURABILITY_MODIFIER = builder.comment(new String[0]).define("Iron Tier durability modifier", (Object)375);
            GOLDEN_TIER_TOOL_DURABILITY_MODIFIER = builder.comment(new String[0]).define("Golden Tier durability modifier", (Object)48);
            DIAMOND_TIER_TOOL_DURABILITY_MODIFIER = builder.comment(new String[0]).define("Diamond Tier durability modifier", (Object)2732);
            NETHERITE_TIER_TOOL_DURABILITY_MODIFIER = builder.comment(new String[0]).define("Netherite Tier durability modifier", (Object)3047);
            EMERALD_TIER_TOOL_DURABILITY_MODIFIER = builder.comment(new String[0]).define("Emerald Tier durability modifier", (Object)2732);
            builder.pop();
            builder.pop();
        }
    }

    private static class CobbleGens {
        CobbleGens(ForgeConfigSpec.Builder builder) {
            builder.comment("Configuration related to Cobblestone Generator").push("Cobblestone Generator");
            builder.comment("Durability cost").push("Costs");
            W_COST = builder.comment(new String[0]).define("Wooden Pickaxe durability cost", (Object)8);
            S_COST = builder.comment(new String[0]).define("Stone Pickaxe durability cost", (Object)16);
            I_COST = builder.comment(new String[0]).define("Iron Pickaxe durability cost", (Object)32);
            G_COST = builder.comment(new String[0]).define("Golden Pickaxe durability cost", (Object)32);
            D_COST = builder.comment(new String[0]).define("Diamond Pickaxe durability cost", (Object)64);
            N_COST = builder.comment(new String[0]).define("Netherite Pickaxe durability cost", (Object)64);
            E_COST = builder.comment(new String[0]).define("Emerald Hammer durability cost", (Object)64);
            builder.pop();
            builder.comment("Cobblestone return amount").push("Returns");
            W_RETURN = builder.comment(new String[0]).define("Wooden Pickaxe cobblestone return amount", (Object)8);
            S_RETURN = builder.comment(new String[0]).define("Stone Pickaxe cobblestone return amount", (Object)16);
            I_RETURN = builder.comment(new String[0]).define("Iron Pickaxe cobblestone return amount", (Object)32);
            G_RETURN = builder.comment(new String[0]).define("Golden Pickaxe cobblestone return amount", (Object)32);
            D_RETURN = builder.comment(new String[0]).define("Diamond Pickaxe cobblestone return amount", (Object)64);
            N_RETURN = builder.comment(new String[0]).define("Netherite Pickaxe cobblestone return amount", (Object)64);
            E_RETURN = builder.comment(new String[0]).define("Emerald Hammer cobblestone return amount", (Object)64);
            builder.pop();
            builder.pop();
        }
    }

    private static class Traps {
        Traps(ForgeConfigSpec.Builder builder) {
            builder.comment("Configuration related to the Traps blocks ").push("Traps");
            GOLDERN_ATTACK_POWER = builder.comment(new String[0]).define("Goldern monster trap attack power modifier", (Object)6);
            DIAMOND_ATTACK_POWER = builder.comment(new String[0]).define("Diamond monster trap attack power modifier", (Object)10);
            WITHER_ATTACK_POWER = builder.comment(new String[0]).define("Wither monster trap attack power modifier", (Object)320);
            builder.pop();
        }
    }

    private static class General {
        General(ForgeConfigSpec.Builder builder) {
            builder.comment("Configuration related to general settings").push("General");
            METALS_ITEMS_LOADED = builder.comment(new String[0]).define("Metal blocks items and berrys are loaded", true);
            GIVEONLOGIN = builder.comment(new String[0]).define("Gives the player the Troll item(s) when loading into a world", true);
            builder.pop();
        }
    }

    private static class Poking_Stick {
        Poking_Stick(ForgeConfigSpec.Builder builder) {
            builder.comment("Configuration related to the Poking Sticks").push("Poking Stick");
            BASE_MAX_USES = builder.comment(new String[0]).define("Base Poking Stick durability  modifier", (Object)59);
            STONE_MAX_USES = builder.comment(new String[0]).define("Stone Poking Stick durability  modifier", (Object)131);
            IRON_MAX_USES = builder.comment(new String[0]).define("Iron Poking Stick durability  modifier", (Object)250);
            SAPLING_DROP_CHANCE = builder.comment(new String[0]).defineInRange("Sapling drop chance modifier", 0.5, 0.0, 1.0);
            CACTUS_DROP_CHANCE = builder.comment(new String[0]).defineInRange("Cactus drop chance modifier", 0.25, 0.0, 1.0);
            builder.pop();
        }
    }

    private static class Magnet {
        Magnet(ForgeConfigSpec.Builder builder) {
            builder.comment("Configuration related to the Magnet item").push("Magnet");
            PICKUP_RANGE = builder.comment("Magnet max pickup range modifier.").defineInRange("Pickup Range", 8, 1, 16);
            builder.pop();
        }
    }

    private static class Viagre {
        Viagre(ForgeConfigSpec.Builder builder) {
            builder.comment("Configuration related to the Viagre item").push("Viagre");
            VIAGRA_MAX_USES = builder.comment(new String[0]).define("VIAGRA durability modifier", (Object)2342);
            VIAGRA_TAKES_USES = builder.comment(new String[0]).define("VIAGRA has a durability cost when in main hand", true);
            VIAGRA_RADIUS = builder.comment("Growth radius size modifier.").defineInRange("Growth Radius", 8, 1, 16);
            VIAGRA_TICK_DELAY = builder.comment("Tick Delay modifier. (Lower is faster)").defineInRange("Tick Delay", 5, 1, 20);
            builder.pop();
        }
    }

    private static class Bookshelf {
        Bookshelf(ForgeConfigSpec.Builder builder) {
            builder.comment("Configuration related to the Booshelf Stairs and Slab").push("Bookshelf");
            ENCHANT_POWER = builder.comment("Enchant power level modifier.").defineInRange("Enchant Level", 1, 1, 16);
            builder.pop();
        }
    }
}

