/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.nohostilesaroundcampfire.events;

import com.natamus.collective.functions.FABFunctions;
import com.natamus.collective.functions.WorldFunctions;
import com.natamus.nohostilesaroundcampfire.config.ConfigHandler;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.state.Property;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.spawner.AbstractSpawner;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CampfireEvent {
    @SubscribeEvent
    public void onEntityJoin(LivingSpawnEvent.CheckSpawn e) {
        AbstractSpawner msbl;
        World world = WorldFunctions.getWorldIfInstanceOfAndNotRemote((IWorld)e.getWorld());
        if (world == null) {
            return;
        }
        Entity entity = e.getEntity();
        if (entity.func_184216_O().contains("nhacampfire.checked")) {
            return;
        }
        entity.func_184211_a("nhacampfire.checked");
        if (((Boolean)ConfigHandler.GENERAL.preventMobSpawnerSpawns.get()).booleanValue() && (msbl = e.getSpawner()) != null) {
            return;
        }
        if (!entity.func_200600_R().func_220339_d().equals((Object)EntityClassification.MONSTER)) {
            return;
        }
        BlockPos campfirepos = FABFunctions.getRequestedBlockAroundEntitySpawn((Block)Blocks.field_222433_lV, (Integer)((Integer)ConfigHandler.GENERAL.preventHostilesRadius.get()), (Double)((Double)ConfigHandler.GENERAL.burnHostilesRadiusModifier.get()), (World)world, (Entity)entity);
        if (campfirepos != null) {
            Boolean islit;
            if (((Boolean)ConfigHandler.GENERAL.campfireMustBeLit.get()).booleanValue() && !(islit = (Boolean)world.func_180495_p(campfirepos).func_177229_b((Property)CampfireBlock.field_220101_b)).booleanValue()) {
                return;
            }
            e.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onCampfirePlace(BlockEvent.EntityPlaceEvent e) {
        World world = WorldFunctions.getWorldIfInstanceOfAndNotRemote((IWorld)e.getWorld());
        if (world == null) {
            return;
        }
        BlockState state = e.getPlacedBlock();
        Block block = state.func_177230_c();
        if (block instanceof CampfireBlock) {
            Boolean islit;
            FABFunctions.updatePlacedBlock((Block)block, (BlockPos)e.getPos(), (World)world);
            if (!((Boolean)ConfigHandler.GENERAL.burnHostilesAroundWhenPlaced.get()).booleanValue()) {
                return;
            }
            if (((Boolean)ConfigHandler.GENERAL.campfireMustBeLit.get()).booleanValue() && !(islit = (Boolean)state.func_177229_b((Property)CampfireBlock.field_220101_b)).booleanValue()) {
                return;
            }
            int r = (Integer)ConfigHandler.GENERAL.preventHostilesRadius.get();
            BlockPos ppos = e.getPos();
            List entities = world.func_72839_b(null, new AxisAlignedBB((double)(ppos.func_177958_n() - r), (double)(ppos.func_177956_o() - r), (double)(ppos.func_177952_p() - r), (double)(ppos.func_177958_n() + r), (double)(ppos.func_177956_o() + r), (double)(ppos.func_177952_p() + r)));
            for (Entity entity : entities) {
                if (!entity.func_200600_R().func_220339_d().equals((Object)EntityClassification.MONSTER)) continue;
                entity.func_70015_d(30);
            }
        }
    }

    @SubscribeEvent
    public void onCampfireBreak(BlockEvent.BreakEvent e) {
        World world = WorldFunctions.getWorldIfInstanceOfAndNotRemote((IWorld)e.getWorld());
        if (world == null) {
            return;
        }
        if (!((Boolean)ConfigHandler.GENERAL.burnHostilesAroundWhenPlaced.get()).booleanValue()) {
            return;
        }
        Block block = e.getState().func_177230_c();
        if (block instanceof CampfireBlock) {
            int r = (Integer)ConfigHandler.GENERAL.preventHostilesRadius.get();
            BlockPos ppos = e.getPos();
            List entities = world.func_72839_b(null, new AxisAlignedBB((double)(ppos.func_177958_n() - r), (double)(ppos.func_177956_o() - r), (double)(ppos.func_177952_p() - r), (double)(ppos.func_177958_n() + r), (double)(ppos.func_177956_o() + r), (double)(ppos.func_177952_p() + r)));
            for (Entity entity : entities) {
                if (!entity.func_200600_R().func_220339_d().equals((Object)EntityClassification.MONSTER) || !entity.func_70027_ad()) continue;
                entity.func_70066_B();
                entity.func_70015_d(2);
            }
        }
    }
}

