/*
 * Decompiled with CFR 0.152.
 */
package com.vandendaelen.nicephore.event;

import com.vandendaelen.nicephore.Nicephore;
import com.vandendaelen.nicephore.gui.ScreenshotScreen;
import com.vandendaelen.nicephore.thread.JPEGThread;
import com.vandendaelen.nicephore.utils.CopyImageToClipBoard;
import com.vandendaelen.nicephore.utils.PlayerHelper;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.client.event.ScreenshotEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="nicephore")
public final class ClientEvents {
    public static KeyBinding COPY_KEY;
    public static KeyBinding GUI_KEY;

    static InputMappings.Input getKey(int key) {
        return InputMappings.Type.KEYSYM.func_197944_a(key);
    }

    public static void init() {
        COPY_KEY = new KeyBinding("nicephore.keybinds.copy", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.CONTROL, ClientEvents.getKey(67), "Nicephore");
        ClientRegistry.registerKeyBinding((KeyBinding)COPY_KEY);
        GUI_KEY = new KeyBinding("nicephore.keybinds.gui", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.CONTROL, ClientEvents.getKey(71), "Nicephore");
        ClientRegistry.registerKeyBinding((KeyBinding)GUI_KEY);
    }

    @SubscribeEvent
    public static void onKey(InputUpdateEvent event) {
        if (COPY_KEY.func_151468_f()) {
            CopyImageToClipBoard imageToClipBoard = new CopyImageToClipBoard();
            try {
                imageToClipBoard.copyLastScreenshot();
                PlayerHelper.sendMessage((ITextComponent)new TranslationTextComponent("nicephore.clipboard.success", new Object[0]));
            }
            catch (IOException e) {
                Nicephore.LOGGER.error(e.getMessage());
                PlayerHelper.sendMessage((ITextComponent)new TranslationTextComponent("nicephore.clipboard.error", new Object[0]));
            }
        }
        if (GUI_KEY.func_151468_f()) {
            if (ScreenshotScreen.canBeShow()) {
                Minecraft.func_71410_x().func_147108_a((Screen)new ScreenshotScreen());
            } else {
                PlayerHelper.sendHotbarMessage((ITextComponent)new TranslationTextComponent("nicephore.clipboard.empty", new Object[0]));
            }
        }
    }

    @SubscribeEvent
    public static void onScreenshot(ScreenshotEvent event) {
        JPEGThread thread = new JPEGThread(event.getImage(), event.getScreenshotFile());
        thread.start();
        event.setResultMessage((ITextComponent)new StringTextComponent(""));
    }
}

