/*
 * Decompiled with CFR 0.152.
 */
package com.vandendaelen.nicephore.gui;

import com.vandendaelen.nicephore.gui.DeleteConfirmScreen;
import com.vandendaelen.nicephore.utils.CopyImageToClipBoard;
import com.vandendaelen.nicephore.utils.Util;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.io.FileUtils;

public class ScreenshotScreen
extends Screen {
    private static final TranslationTextComponent TITLE = new TranslationTextComponent("nicephore.gui.screenshots", new Object[0]);
    private static final File SCREENSHOTS_DIR = new File(Minecraft.func_71410_x().field_71412_D, "screenshots");
    private static final TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
    private static ResourceLocation SCREENSHOT_TEXTURE;
    private ArrayList<File> screenshots;
    private static int index;
    private float aspectRatio;

    public ScreenshotScreen() {
        super((ITextComponent)TITLE);
        FilenameFilter filter = (dir, name) -> name.endsWith(".jpg") || name.endsWith(".png");
        this.screenshots = (ArrayList)Arrays.stream(SCREENSHOTS_DIR.listFiles(filter)).collect(Collectors.toList());
        index = this.getIndex();
        this.aspectRatio = 1.7777f;
    }

    protected void init() {
        super.init();
        if (this.screenshots.isEmpty()) {
            this.onClose();
            return;
        }
        BufferedImage bimg = null;
        try {
            bimg = ImageIO.read(this.screenshots.get(index));
            int width = bimg.getWidth();
            int height = bimg.getHeight();
            bimg.getGraphics().dispose();
            this.aspectRatio = (float)((double)width / (double)height);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        textureManager.func_147645_c(SCREENSHOT_TEXTURE);
        SCREENSHOT_TEXTURE = Util.fileTotexture(this.screenshots.get(index));
        this.buttons.clear();
        this.addButton((Widget)new Button(this.width / 2 + 50, this.height / 2 + 75, 20, 20, new StringTextComponent(">").func_150261_e(), button -> this.modIndex(1)));
        this.addButton((Widget)new Button(this.width / 2 - 80, this.height / 2 + 75, 20, 20, new StringTextComponent("<").func_150261_e(), button -> this.modIndex(-1)));
        this.addButton((Widget)new Button(this.width / 2 - 55, this.height / 2 + 75, 50, 20, new TranslationTextComponent("nicephore.gui.screenshots.copy", new Object[0]).func_150261_e(), button -> {
            CopyImageToClipBoard imageToClipBoard = new CopyImageToClipBoard();
            try {
                imageToClipBoard.copyImage(ImageIO.read(this.screenshots.get(index)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }));
        this.addButton((Widget)new Button(this.width / 2 - 5, this.height / 2 + 75, 50, 20, new TranslationTextComponent("nicephore.gui.screenshots.delete", new Object[0]).func_150261_e(), button -> this.deleteScreenshot(this.screenshots.get(index))));
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        textureManager.func_110577_a(SCREENSHOT_TEXTURE);
        int centerX = this.width / 2;
        int width = (int)((double)this.width * 0.5);
        int height = (int)((float)width / this.aspectRatio);
        ScreenshotScreen.blit((int)(centerX - width / 2), (int)50, (float)0.0f, (float)0.0f, (int)width, (int)height, (int)width, (int)height);
        this.drawCenteredString(Minecraft.func_71410_x().field_71466_p, new TranslationTextComponent("nicephore.gui.screenshots.pages", new Object[]{index + 1, this.screenshots.size()}).func_150261_e(), centerX, 20, Color.WHITE.getRGB());
        this.drawCenteredString(Minecraft.func_71410_x().field_71466_p, new StringTextComponent(MessageFormat.format("{0} ({1})", this.screenshots.get(index).getName(), ScreenshotScreen.getFileSizeMegaBytes(this.screenshots.get(index)))).func_150261_e(), centerX, 35, Color.WHITE.getRGB());
    }

    private void modIndex(int value) {
        int max = this.screenshots.size();
        index = index + value >= 0 && index + value < max ? (index += value) : (index + value < 0 ? max - 1 : 0);
        this.init();
    }

    private void deleteScreenshot(File file) {
        Minecraft.func_71410_x().func_147108_a((Screen)new DeleteConfirmScreen(file));
    }

    private int getIndex() {
        if (index >= this.screenshots.size() || index < 0) {
            index = this.screenshots.size() - 1;
        }
        return index;
    }

    public static boolean canBeShow() {
        return SCREENSHOTS_DIR.list().length > 0;
    }

    private static String getFileSizeMegaBytes(File file) {
        double size = FileUtils.sizeOf((File)file);
        DecimalFormat formatter = new DecimalFormat("#0.00");
        int MB_SIZE = 0x100000;
        int KB_SIZE = 1024;
        if (size > 1048576.0) {
            return MessageFormat.format("{0} MB", formatter.format((double)FileUtils.sizeOf((File)file) / 1048576.0));
        }
        return MessageFormat.format("{0} KB", formatter.format((double)FileUtils.sizeOf((File)file) / 1024.0));
    }
}

