/*
 * Decompiled with CFR 0.152.
 */
package com.vandendaelen.nicephore.thread;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.vandendaelen.nicephore.config.NicephoreConfig;
import com.vandendaelen.nicephore.utils.Reference;
import com.vandendaelen.nicephore.utils.Util;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraft.client.Minecraft;
import org.apache.commons.io.FileUtils;

public final class InitThread
extends Thread {
    private static final File DESTINATION = new File(Minecraft.func_71410_x().field_71412_D.getAbsolutePath(), "mods\\nicephore");
    private static final File REFERENCES_JSON = new File(DESTINATION, "\\references.json");
    private static final File OXIPNG_ZIP = new File(DESTINATION, "\\oxipng.zip");
    private static final File ECT_ZIP = new File(DESTINATION, "\\ect.zip");

    @Override
    public void run() {
        if (NicephoreConfig.Client.getOptimisedOutputToggle()) {
            if (Files.exists(DESTINATION.toPath(), new LinkOption[0])) {
                Optional<Response> response;
                try {
                    response = this.getResponse(this.getJsonReader(REFERENCES_JSON));
                    if (response.isPresent()) {
                        Reference.Command.OXIPNG = response.get().oxipng_command;
                        Reference.Command.ECT = response.get().ect_command;
                        Reference.File.OXIPNG = response.get().oxipng_file;
                        Reference.File.ECT = response.get().ect_file;
                        Reference.Version.OXIPNG = response.get().oxipng_version;
                        Reference.Version.ECT = response.get().ect_version;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    response = this.getResponse(this.getJsonReader("https://raw.githubusercontent.com/LotuxPunk/Nicephore/master/references/v1.1/REFERENCES.json", REFERENCES_JSON));
                    if (response.isPresent()) {
                        if (!Reference.Version.OXIPNG.equals(response.get().oxipng_version)) {
                            Reference.Version.OXIPNG = response.get().oxipng_version;
                            InitThread.downloadAndExtract(response.get().oxipng, OXIPNG_ZIP);
                        }
                        if (!Reference.Version.ECT.equals(response.get().ect_version)) {
                            Reference.Version.ECT = response.get().ect_version;
                            InitThread.downloadAndExtract(response.get().ect, ECT_ZIP);
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                this.freshInstall();
            }
        }
    }

    private static void downloadAndExtract(String url, File zip) {
        try (BufferedInputStream in = new BufferedInputStream(new URL(url).openStream());
             FileOutputStream fileOutputStream = new FileOutputStream(zip);){
            int bytesRead;
            byte[] dataBuffer = new byte[1024];
            while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                fileOutputStream.write(dataBuffer, 0, bytesRead);
            }
            InitThread.unzip(zip.getAbsolutePath(), DESTINATION.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void unzip(String zipFilePath, String destDir) {
        File dir = new File(destDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        byte[] buffer = new byte[1024];
        try {
            FileInputStream fis = new FileInputStream(zipFilePath);
            ZipInputStream zis = new ZipInputStream(fis);
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                int len;
                String fileName = ze.getName();
                File newFile = new File(destDir + File.separator + fileName);
                System.out.println("Unzipping to " + newFile.getAbsolutePath());
                new File(newFile.getParent()).mkdirs();
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
                zis.closeEntry();
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Optional<Response> getResponse(JsonReader reader) {
        Gson gson = new Gson();
        Type collectionType = new TypeToken<Collection<Response>>(){}.getType();
        Collection responses = (Collection)gson.fromJson(reader, collectionType);
        Optional<Response> response = responses.stream().filter(response1 -> response1.platform.equals(Util.getOS().name())).findFirst();
        return response;
    }

    private JsonReader getJsonReader(String URL2, File file) throws IOException {
        FileUtils.copyURLToFile((URL)new URL(URL2), (File)file);
        return this.getJsonReader(file);
    }

    private JsonReader getJsonReader(File file) throws FileNotFoundException {
        return new JsonReader((Reader)new FileReader(file));
    }

    private final void freshInstall() {
        try {
            Files.createDirectory(DESTINATION.toPath(), new FileAttribute[0]);
            Optional<Response> response = this.getResponse(this.getJsonReader("https://raw.githubusercontent.com/LotuxPunk/Nicephore/master/references/v1.1/REFERENCES.json", REFERENCES_JSON));
            Reference.Command.OXIPNG = response.get().oxipng_command;
            Reference.Command.ECT = response.get().ect_command;
            Reference.File.OXIPNG = response.get().oxipng_file;
            Reference.File.ECT = response.get().ect_file;
            Reference.Version.OXIPNG = response.get().oxipng_version;
            Reference.Version.ECT = response.get().ect_version;
            InitThread.downloadAndExtract(response.get().oxipng, OXIPNG_ZIP);
            InitThread.downloadAndExtract(response.get().ect, ECT_ZIP);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static class Response {
        String platform;
        String oxipng;
        String oxipng_file;
        String oxipng_command;
        String oxipng_version;
        String ect;
        String ect_file;
        String ect_command;
        String ect_version;

        Response() {
        }
    }
}

