/*
 * Decompiled with CFR 0.152.
 */
package com.vandendaelen.nicephore.thread;

import com.vandendaelen.nicephore.Nicephore;
import com.vandendaelen.nicephore.config.NicephoreConfig;
import com.vandendaelen.nicephore.utils.CopyImageToClipBoard;
import com.vandendaelen.nicephore.utils.PlayerHelper;
import com.vandendaelen.nicephore.utils.Reference;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;

public final class JPEGThread
extends Thread {
    private final NativeImage image;
    private final File screenshot;

    public JPEGThread(NativeImage image, File screenshot) {
        this.image = image;
        this.screenshot = screenshot;
    }

    @Override
    public void run() {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.image.func_227796_e_());
            BufferedImage png = ImageIO.read(bais);
            File jpegFile = new File(this.screenshot.getParentFile(), this.screenshot.getName().replace("png", "jpg"));
            BufferedImage result = new BufferedImage(png.getWidth(), png.getHeight(), 1);
            result.createGraphics().drawImage(png, 0, 0, Color.WHITE, null);
            if (NicephoreConfig.Client.getJPEGToggle()) {
                ImageWriter writer = ImageIO.getImageWritersByFormatName("jpg").next();
                ImageWriteParam params = writer.getDefaultWriteParam();
                params.setCompressionMode(2);
                params.setProgressiveMode(1);
                params.setCompressionQuality(NicephoreConfig.Client.getCompressionLevel());
                writer.setOutput(new FileImageOutputStream(jpegFile));
                writer.write(null, new IIOImage(result, null, null), params);
            }
            if (NicephoreConfig.Client.getOptimisedOutputToggle()) {
                boolean shouldShowOptStatus = NicephoreConfig.Client.getShouldShowOptStatus();
                if (shouldShowOptStatus) {
                    PlayerHelper.sendHotbarMessage((ITextComponent)new TranslationTextComponent("nicephore.screenshot.optimize", new Object[0]));
                }
                if (NicephoreConfig.Client.getJPEGToggle()) {
                    try {
                        File ect = new File("mods\\nicephore\\" + Reference.File.ECT);
                        Process p = Runtime.getRuntime().exec(MessageFormat.format(Reference.Command.ECT, ect, jpegFile));
                        p.waitFor();
                    }
                    catch (IOException | InterruptedException e) {
                        Nicephore.LOGGER.warn("Unable to optimise screenshot JPEG with ECT. Is it missing from the mods folder?");
                        Nicephore.LOGGER.warn(e.getMessage());
                    }
                }
                try {
                    File oxipng = new File("mods\\nicephore\\" + Reference.File.OXIPNG);
                    File pngFile = new File(this.screenshot.getParentFile(), this.screenshot.getName());
                    Process p = Runtime.getRuntime().exec(MessageFormat.format(Reference.Command.OXIPNG, oxipng, NicephoreConfig.Client.getPNGOptimisationLevel(), pngFile));
                    p.waitFor();
                }
                catch (IOException | InterruptedException e) {
                    Nicephore.LOGGER.warn("Unable to optimise screenshot PNG with Oxipng. Is it missing from the mods folder?");
                    Nicephore.LOGGER.warn(e.getMessage());
                }
                if (shouldShowOptStatus) {
                    PlayerHelper.sendHotbarMessage((ITextComponent)new TranslationTextComponent("nicephore.screenshot.optimizeFinished", new Object[0]));
                }
            }
            CopyImageToClipBoard.setLastScreenshot(this.screenshot);
            ITextComponent pngComponent = new TranslationTextComponent("nicephore.screenshot.png", new Object[0]).func_211709_a(new TextFormatting[]{TextFormatting.UNDERLINE}).func_211710_a(style -> style.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, this.screenshot.getAbsolutePath())));
            ITextComponent jpgComponent = new TranslationTextComponent("nicephore.screenshot.jpg", new Object[0]).func_211709_a(new TextFormatting[]{TextFormatting.UNDERLINE}).func_211710_a(style -> style.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, jpegFile.getAbsolutePath())));
            ITextComponent folderComponent = new TranslationTextComponent("nicephore.screenshot.folder", new Object[0]).func_211709_a(new TextFormatting[]{TextFormatting.UNDERLINE}).func_211710_a(style -> style.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, this.screenshot.getParent())));
            PlayerHelper.sendMessage((ITextComponent)new TranslationTextComponent("nicephore.screenshot.success", new Object[]{this.screenshot.getName().replace(".png", "")}));
            if (NicephoreConfig.Client.getJPEGToggle()) {
                PlayerHelper.sendMessage((ITextComponent)new TranslationTextComponent("nicephore.screenshot.options", new Object[]{pngComponent, jpgComponent, folderComponent}));
            } else {
                PlayerHelper.sendMessage((ITextComponent)new TranslationTextComponent("nicephore.screenshot.reducedOptions", new Object[]{pngComponent, folderComponent}));
            }
        }
        catch (IOException e) {
            Nicephore.LOGGER.error(e.getMessage());
            PlayerHelper.sendMessage((ITextComponent)new TranslationTextComponent("nicephore.screenshot.error", new Object[0]));
        }
    }
}

