/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.odimod;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mcreator.odimod.OdimodMod;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.forgespi.language.ModFileScanData;

public class OdimodModElements {
    public final List<ModElement> elements = new ArrayList<ModElement>();
    public final List<Supplier<Block>> blocks = new ArrayList<Supplier<Block>>();
    public final List<Supplier<Item>> items = new ArrayList<Supplier<Item>>();
    public final List<Supplier<Biome>> biomes = new ArrayList<Supplier<Biome>>();
    public final List<Supplier<EntityType<?>>> entities = new ArrayList();
    public final List<Supplier<Enchantment>> enchantments = new ArrayList<Supplier<Enchantment>>();
    public static Map<ResourceLocation, SoundEvent> sounds = new HashMap<ResourceLocation, SoundEvent>();
    private int messageID = 0;

    public OdimodModElements() {
        sounds.put(new ResourceLocation("odimod", "hammer1"), new SoundEvent(new ResourceLocation("odimod", "hammer1")));
        sounds.put(new ResourceLocation("odimod", "healing1"), new SoundEvent(new ResourceLocation("odimod", "healing1")));
        sounds.put(new ResourceLocation("odimod", "gm"), new SoundEvent(new ResourceLocation("odimod", "gm")));
        sounds.put(new ResourceLocation("odimod", "mdeath"), new SoundEvent(new ResourceLocation("odimod", "mdeath")));
        sounds.put(new ResourceLocation("odimod", "mhurt"), new SoundEvent(new ResourceLocation("odimod", "mhurt")));
        sounds.put(new ResourceLocation("odimod", "m1"), new SoundEvent(new ResourceLocation("odimod", "m1")));
        sounds.put(new ResourceLocation("odimod", "mwave"), new SoundEvent(new ResourceLocation("odimod", "mwave")));
        sounds.put(new ResourceLocation("odimod", "arch_illager_spell"), new SoundEvent(new ResourceLocation("odimod", "arch_illager_spell")));
        sounds.put(new ResourceLocation("odimod", "skshield"), new SoundEvent(new ResourceLocation("odimod", "skshield")));
        sounds.put(new ResourceLocation("odimod", "mushroom"), new SoundEvent(new ResourceLocation("odimod", "mushroom")));
        sounds.put(new ResourceLocation("odimod", "hide"), new SoundEvent(new ResourceLocation("odimod", "hide")));
        sounds.put(new ResourceLocation("odimod", "lightningrod"), new SoundEvent(new ResourceLocation("odimod", "lightningrod")));
        sounds.put(new ResourceLocation("odimod", "oak"), new SoundEvent(new ResourceLocation("odimod", "oak")));
        sounds.put(new ResourceLocation("odimod", "whip1"), new SoundEvent(new ResourceLocation("odimod", "whip1")));
        sounds.put(new ResourceLocation("odimod", "whipunic"), new SoundEvent(new ResourceLocation("odimod", "whipunic")));
        sounds.put(new ResourceLocation("odimod", "seeds"), new SoundEvent(new ResourceLocation("odimod", "seeds")));
        sounds.put(new ResourceLocation("odimod", "archhurt"), new SoundEvent(new ResourceLocation("odimod", "archhurt")));
        sounds.put(new ResourceLocation("odimod", "archambient"), new SoundEvent(new ResourceLocation("odimod", "archambient")));
        sounds.put(new ResourceLocation("odimod", "heartambient"), new SoundEvent(new ResourceLocation("odimod", "heartambient")));
        sounds.put(new ResourceLocation("odimod", "archdeath"), new SoundEvent(new ResourceLocation("odimod", "archdeath")));
        try {
            ModFileScanData modFileInfo = ModList.get().getModFileById("odimod").getFile().getScanResult();
            Set annotations = modFileInfo.getAnnotations();
            for (ModFileScanData.AnnotationData annotationData : annotations) {
                Class<?> clazz;
                if (!annotationData.getAnnotationType().getClassName().equals(ModElement.Tag.class.getName()) || (clazz = Class.forName(annotationData.getClassType().getClassName())).getSuperclass() != ModElement.class) continue;
                this.elements.add((ModElement)clazz.getConstructor(this.getClass()).newInstance(this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(this.elements);
        this.elements.forEach(ModElement::initElements);
    }

    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (Map.Entry<ResourceLocation, SoundEvent> sound : sounds.entrySet()) {
            event.getRegistry().register(sound.getValue().setRegistryName(sound.getKey()));
        }
    }

    public <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        OdimodMod.PACKET_HANDLER.registerMessage(this.messageID, messageType, encoder, decoder, messageConsumer);
        ++this.messageID;
    }

    public List<ModElement> getElements() {
        return this.elements;
    }

    public List<Supplier<Block>> getBlocks() {
        return this.blocks;
    }

    public List<Supplier<Item>> getItems() {
        return this.items;
    }

    public List<Supplier<Biome>> getBiomes() {
        return this.biomes;
    }

    public List<Supplier<EntityType<?>>> getEntities() {
        return this.entities;
    }

    public List<Supplier<Enchantment>> getEnchantments() {
        return this.enchantments;
    }

    public static class ModElement
    implements Comparable<ModElement> {
        protected final OdimodModElements elements;
        protected final int sortid;

        public ModElement(OdimodModElements elements, int sortid) {
            this.elements = elements;
            this.sortid = sortid;
        }

        public void initElements() {
        }

        public void init(FMLCommonSetupEvent event) {
        }

        public void serverLoad(FMLServerStartingEvent event) {
        }

        @OnlyIn(value=Dist.CLIENT)
        public void clientLoad(FMLClientSetupEvent event) {
        }

        @Override
        public int compareTo(ModElement other) {
            return this.sortid - other.sortid;
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface Tag {
        }
    }
}

