/*
 * Decompiled with CFR 0.152.
 */
package de.geekeey.packed.block;

import de.geekeey.packed.block.entity.VariantCrateBlockEntity;
import de.geekeey.packed.init.helpers.StorageTier;
import de.geekeey.packed.init.helpers.WoodVariant;
import java.util.UUID;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;

public class VariantCrateBlock
extends class_2237 {
    private static final int dropSize = 16;
    private static final int shiftingDropSize = 64;
    private static final int doubleUseInterval = 10;
    private UUID lastUsedPlayer;
    private long lastUsedTime;
    public static final class_2753 FACING = class_2741.field_12481;
    private final StorageTier tier;
    private final WoodVariant variant;

    public VariantCrateBlock(@NotNull StorageTier tier, @NotNull WoodVariant variant) {
        super((class_4970.class_2251)FabricBlockSettings.copyOf((class_4970)class_2246.field_16328));
        this.tier = tier;
        this.variant = variant;
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
    }

    @NotNull
    public StorageTier getTier() {
        return this.tier;
    }

    @NotNull
    public WoodVariant getVariant() {
        return this.variant;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING});
    }

    public class_2586 method_10123(class_1922 world) {
        return new VariantCrateBlockEntity(this.getTier(), this.getVariant());
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!world.field_9236) {
            VariantCrateBlockEntity crate = (VariantCrateBlockEntity)world.method_8321(pos);
            assert (crate != null);
            class_1799 stack = player.method_5998(hand);
            if (!crate.isFull()) {
                if ((crate.getItem().equals(class_1802.field_8162) || crate.getItem().equals(stack.method_7909())) && stack.method_7946() && !stack.method_7985()) {
                    class_1799 insert = crate.insert(stack);
                    stack.method_7939(insert.method_7947());
                } else if (player.method_5667().equals(this.lastUsedPlayer) && world.method_8510() - this.lastUsedTime < 10L) {
                    class_1661 inv = player.field_7514;
                    for (int i = 0; i < inv.method_5439(); ++i) {
                        class_1799 currentStack = inv.method_5438(i);
                        if (currentStack.method_7960() || !crate.getItem().equals(currentStack.method_7909())) continue;
                        class_1799 insert = crate.insertAll(currentStack);
                        currentStack.method_7939(insert.method_7947());
                        if (!insert.method_7960()) break;
                    }
                }
            }
            this.lastUsedPlayer = player.method_5667();
            this.lastUsedTime = world.method_8510();
            return class_1269.field_5812;
        }
        return class_1269.field_21466;
    }

    private boolean insertInBarrel(class_1799 insert, VariantCrateBlockEntity inv) {
        class_1799 barrelStack = inv.method_5438(0);
        int barrelCount = barrelStack.method_7947();
        if (barrelStack.method_7909() != insert.method_7909()) {
            throw new IllegalArgumentException("Stack to be inserted must have same item as barrel content");
        }
        int remainingSpace = inv.method_5444() - barrelStack.method_7947();
        if (remainingSpace < insert.method_7947()) {
            barrelStack.method_7939(inv.method_5444());
            insert.method_7939(insert.method_7947() - remainingSpace);
            return false;
        }
        barrelStack.method_7939(barrelCount + insert.method_7947());
        insert.method_7939(0);
        return true;
    }

    public void method_9606(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        if (!world.field_9236) {
            VariantCrateBlockEntity crate = (VariantCrateBlockEntity)world.method_8321(pos);
            assert (crate != null);
            int size = player.method_5715() ? Math.min(64, crate.getItem().method_7882()) : 16;
            class_1799 result = class_1799.field_8037;
            for (int i = 0; i < crate.method_5439(); ++i) {
                class_1799 stack = crate.method_5434(i, size);
                if (stack.method_7960()) continue;
                if (stack.method_7947() == size) {
                    result = stack;
                    break;
                }
                if (result.method_7960()) {
                    result = stack;
                    continue;
                }
                result.method_7933(stack.method_7947());
                if (result.method_7947() == size) break;
            }
            if (crate.getItem().equals(class_1802.field_8162)) {
                crate.sync();
            }
            player.field_7514.method_7398(world, result);
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!state.method_27852(newState.method_26204()) && !(newState.method_26204() instanceof VariantCrateBlock)) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof class_1263) {
                class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)((class_1263)blockEntity));
                world.method_8455(pos, (class_2248)this);
            }
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042().method_10153());
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return class_1703.method_7608((class_2586)world.method_8321(pos));
    }
}

