/*
 * Decompiled with CFR 0.152.
 */
package de.geekeey.packed.client.render;

import com.google.common.collect.ImmutableMap;
import de.geekeey.packed.Packed;
import de.geekeey.packed.block.VariantChestBlock;
import de.geekeey.packed.block.entity.VariantChestBlockEntity;
import de.geekeey.packed.init.helpers.StorageTier;
import de.geekeey.packed.init.helpers.StorageTiers;
import de.geekeey.packed.init.helpers.WoodVariant;
import de.geekeey.packed.init.helpers.WoodVariants;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.minecraft.class_1160;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2350;
import net.minecraft.class_2618;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_4732;
import net.minecraft.class_4737;
import net.minecraft.class_630;
import net.minecraft.class_824;
import net.minecraft.class_827;

public class VariantChestBlockEntityRenderer
extends class_827<VariantChestBlockEntity> {
    private static final class_2960 CHEST_ATLAS_TEXTURE = class_4722.field_21709;
    private static final class_4730 CLINCH_DEFAULT = VariantChestBlockEntityRenderer.createChestTextureId(StorageTiers.DEFAULT.getIdentifier());
    private static final class_4730 CLINCH_TIER_1 = VariantChestBlockEntityRenderer.createChestTextureId(StorageTiers.TIER_1.getIdentifier());
    private static final class_4730 CLINCH_TIER_2 = VariantChestBlockEntityRenderer.createChestTextureId(StorageTiers.TIER_2.getIdentifier());
    private static final class_4730 CLINCH_TIER_3 = VariantChestBlockEntityRenderer.createChestTextureId(StorageTiers.TIER_3.getIdentifier());
    private static final ImmutableMap<WoodVariant, ChestTextureSprites> WOOD_VARIANT_SPRITES;
    private final class_630 headerSingleModel;
    private final class_630 footerSingleModel;
    private final class_630 clinchSingleModel;
    private final class_630 headerRightModel;
    private final class_630 footerRightModel;
    private final class_630 clinchRightModel;
    private final class_630 headerLeftModel;
    private final class_630 footerLeftModel;
    private final class_630 clinchLeftModel;
    private final class_2248 fallback;

    public VariantChestBlockEntityRenderer(class_824 dispatcher, class_2248 fallback) {
        super(dispatcher);
        this.fallback = fallback;
        this.footerSingleModel = new class_630(64, 64, 0, 19);
        this.footerSingleModel.method_2856(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f, 0.0f);
        this.headerSingleModel = new class_630(64, 64, 0, 0);
        this.headerSingleModel.method_2856(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f, 0.0f);
        this.headerSingleModel.field_3656 = 9.0f;
        this.headerSingleModel.field_3655 = 1.0f;
        this.clinchSingleModel = new class_630(16, 16, 0, 0);
        this.clinchSingleModel.method_2856(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f, 0.0f);
        this.clinchSingleModel.field_3656 = 8.0f;
        this.footerRightModel = new class_630(64, 64, 0, 19);
        this.footerRightModel.method_2856(1.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f, 0.0f);
        this.headerRightModel = new class_630(64, 64, 0, 0);
        this.headerRightModel.method_2856(1.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f, 0.0f);
        this.headerRightModel.field_3656 = 9.0f;
        this.headerRightModel.field_3655 = 1.0f;
        this.clinchRightModel = new class_630(16, 16, 8, 0);
        this.clinchRightModel.method_2856(15.0f, -1.0f, 15.0f, 1.0f, 4.0f, 1.0f, 0.0f);
        this.clinchRightModel.field_3656 = 8.0f;
        this.footerLeftModel = new class_630(64, 64, 0, 19);
        this.footerLeftModel.method_2856(0.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f, 0.0f);
        this.headerLeftModel = new class_630(64, 64, 0, 0);
        this.headerLeftModel.method_2856(0.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f, 0.0f);
        this.headerLeftModel.field_3656 = 9.0f;
        this.headerLeftModel.field_3655 = 1.0f;
        this.clinchLeftModel = new class_630(16, 16, 0, 8);
        this.clinchLeftModel.method_2856(0.0f, -1.0f, 15.0f, 1.0f, 4.0f, 1.0f, 0.0f);
        this.clinchLeftModel.field_3656 = 8.0f;
    }

    private static class_4730 createChestTextureId(class_2960 path) {
        return new class_4730(CHEST_ATLAS_TEXTURE, Packed.id("entity/chest/" + path.method_12832()));
    }

    private static class_4730 forChestTier(StorageTier tier) {
        if (tier instanceof StorageTiers) {
            StorageTiers tiers = (StorageTiers)tier;
            switch (tiers) {
                case DEFAULT: {
                    return CLINCH_DEFAULT;
                }
                case TIER_1: {
                    return CLINCH_TIER_1;
                }
                case TIER_2: {
                    return CLINCH_TIER_2;
                }
                case TIER_3: {
                    return CLINCH_TIER_3;
                }
            }
        }
        return CLINCH_DEFAULT;
    }

    public void render(VariantChestBlockEntity entity, float delta, class_4587 matrices, class_4597 vertices, int light, int overlay) {
        class_1937 world = entity.method_10997();
        boolean hasWorld = world != null;
        class_2680 state = hasWorld ? entity.method_11010() : (class_2680)this.fallback.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)class_2350.field_11035);
        class_2745 type = state.method_28498((class_2769)class_2281.field_10770) ? (class_2745)state.method_11654((class_2769)class_2281.field_10770) : class_2745.field_12569;
        class_2248 block = state.method_26204();
        if (block instanceof VariantChestBlock) {
            VariantChestBlock chest = (VariantChestBlock)block;
            matrices.method_22903();
            float facing = ((class_2350)state.method_11654((class_2769)class_2281.field_10768)).method_10144();
            matrices.method_22904(0.5, 0.5, 0.5);
            matrices.method_22907(class_1160.field_20705.method_23214(-facing));
            matrices.method_22904(-0.5, -0.5, -0.5);
            class_4732.class_4734 source = hasWorld ? chest.method_24167(state, world, entity.method_11016(), true) : class_4732.class_3923::method_24174;
            float g = ((Float2FloatFunction)source.apply(class_2281.method_24166((class_2618)entity))).get(delta);
            g = 1.0f - g;
            g = 1.0f - g * g * g;
            int i = ((Int2IntFunction)source.apply((class_4732.class_3923)new class_4737())).applyAsInt(light);
            class_4730 foundation = VariantChestBlockEntityRenderer.fromWoodVariant(chest.getVariant(), type);
            class_4588 verticesFoundation = foundation.method_24145(vertices, class_1921::method_23576);
            class_4730 clinch = VariantChestBlockEntityRenderer.forChestTier(entity.getTier());
            class_4588 verticesClinch = clinch.method_24145(vertices, class_1921::method_23576);
            if (type == class_2745.field_12569) {
                this.renderParts(matrices, verticesFoundation, verticesClinch, this.headerSingleModel, this.clinchSingleModel, this.footerSingleModel, g, i, overlay);
            } else if (type == class_2745.field_12574) {
                this.renderParts(matrices, verticesFoundation, verticesClinch, this.headerLeftModel, this.clinchLeftModel, this.footerLeftModel, g, i, overlay);
            } else {
                this.renderParts(matrices, verticesFoundation, verticesClinch, this.headerRightModel, this.clinchRightModel, this.footerRightModel, g, i, overlay);
            }
            matrices.method_22909();
        }
    }

    private void renderParts(class_4587 matrices, class_4588 chestVertices, class_4588 lockVertices, class_630 header, class_630 clinch, class_630 footer, float f, int light, int overlay) {
        clinch.field_3654 = header.field_3654 = -(f * 1.5707964f);
        header.method_22698(matrices, chestVertices, light, overlay);
        clinch.method_22698(matrices, lockVertices, light, overlay);
        footer.method_22698(matrices, chestVertices, light, overlay);
    }

    private static class_4730 fromWoodVariant(WoodVariant chest, class_2745 type) {
        ChestTextureSprites sprites = (ChestTextureSprites)WOOD_VARIANT_SPRITES.get((Object)chest);
        switch (type) {
            case field_12574: {
                return sprites.left;
            }
            case field_12571: {
                return sprites.right;
            }
        }
        return sprites.normal;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (WoodVariants variant : WoodVariants.values()) {
            builder.put((Object)variant, (Object)new ChestTextureSprites(variant));
        }
        WOOD_VARIANT_SPRITES = builder.build();
    }

    private static class ChestTextureSprites {
        public final class_4730 normal;
        public final class_4730 left;
        public final class_4730 right;

        public ChestTextureSprites(WoodVariant variant) {
            this.left = new class_4730(CHEST_ATLAS_TEXTURE, Packed.id("entity/chest/" + variant.getIdentifier().method_12832() + "/normal_left"));
            this.right = new class_4730(CHEST_ATLAS_TEXTURE, Packed.id("entity/chest/" + variant.getIdentifier().method_12832() + "/normal_right"));
            this.normal = new class_4730(CHEST_ATLAS_TEXTURE, Packed.id("entity/chest/" + variant.getIdentifier().method_12832() + "/normal"));
        }
    }
}

