/*
 * Decompiled with CFR 0.152.
 */
package de.geekeey.packed.init.helpers;

import de.geekeey.packed.Packed;
import de.geekeey.packed.init.helpers.StorageTier;
import java.util.Optional;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public enum StorageTiers implements StorageTier
{
    DEFAULT("default", 1, 9, 3, 32),
    TIER_1("tier1", 2, 9, 4, 64),
    TIER_2("tier2", 3, 9, 5, 96),
    TIER_3("tier3", -1, 9, 6, 128);

    private final class_2960 identifier;
    private final int upgrade;
    private final int inventoryWidth;
    private final int inventoryHeight;
    private final int stackSize;

    private StorageTiers(String id, int upgrade, int inventoryWidth, int inventoryHeight, int stackSize) {
        this.identifier = Packed.id(id);
        this.upgrade = upgrade;
        this.inventoryWidth = inventoryWidth;
        this.inventoryHeight = inventoryHeight;
        this.stackSize = stackSize;
    }

    @Override
    public class_2960 getIdentifier() {
        return this.identifier;
    }

    @Override
    public Optional<StorageTier> getUpgradeTier() {
        return Optional.ofNullable((StorageTier)StorageTiers.check(this.upgrade, StorageTiers.values()));
    }

    @Override
    public int getInventoryWidth() {
        return this.inventoryWidth;
    }

    @Override
    public int getInventoryHeight() {
        return this.inventoryHeight;
    }

    @Override
    public int getStackAmount() {
        return this.stackSize;
    }

    @Nullable
    private static <T> T check(int index, T[] values) {
        if (index < 0 || index >= StorageTiers.values().length) {
            return null;
        }
        return values[index];
    }

    static {
        for (StorageTiers tier : StorageTiers.values()) {
            class_2378.method_10230(StorageTier.REGISTRY, (class_2960)tier.getIdentifier(), (Object)tier);
        }
    }
}

