/*
 * Decompiled with CFR 0.152.
 */
package de.geekeey.packed.init.helpers;

import com.google.common.collect.ImmutableMap;
import de.geekeey.packed.init.helpers.WoodVariant;
import de.geekeey.packed.init.helpers.WoodVariants;
import java.util.Iterator;
import java.util.function.BiFunction;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class WoodBlockVariants<T, B extends class_2248>
implements Iterable<B> {
    public final ImmutableMap<WoodVariant, B> variants;
    public final T tier;

    public WoodBlockVariants(T tier, BiFunction<T, WoodVariant, class_2960> id, BiFunction<T, WoodVariant, B> factory) {
        this.tier = tier;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (WoodVariants variant : WoodVariants.values()) {
            class_2960 identifier = id.apply(tier, variant);
            class_2248 block = (class_2248)factory.apply(tier, variant);
            class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)identifier, (Object)block);
            builder.put((Object)variant, (Object)block);
        }
        this.variants = builder.build();
    }

    public B oak() {
        return (B)((class_2248)this.variants.get((Object)WoodVariants.OAK));
    }

    public B spruce() {
        return (B)((class_2248)this.variants.get((Object)WoodVariants.SPRUCE));
    }

    public B birch() {
        return (B)((class_2248)this.variants.get((Object)WoodVariants.BIRCH));
    }

    public B acacia() {
        return (B)((class_2248)this.variants.get((Object)WoodVariants.ACACIA));
    }

    public B jungle() {
        return (B)((class_2248)this.variants.get((Object)WoodVariants.JUNGLE));
    }

    public B darkOak() {
        return (B)((class_2248)this.variants.get((Object)WoodVariants.DARK_OAK));
    }

    public B crimson() {
        return (B)((class_2248)this.variants.get((Object)WoodVariants.CRIMSON));
    }

    public B warped() {
        return (B)((class_2248)this.variants.get((Object)WoodVariants.WARPED));
    }

    @Override
    @NotNull
    public Iterator<B> iterator() {
        return this.variants.values().iterator();
    }
}

