/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockStateMatcher;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.ForgeRegistries;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.capabilities.PlayerState;

@Mod.EventBusSubscriber(modid="paraglider", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ModCfg {
    private static ForgeConfigSpec.BooleanValue ascendingWinds;
    private static ForgeConfigSpec.BooleanValue paraglidingConsumesStamina;
    private static ForgeConfigSpec.BooleanValue runningConsumesStamina;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> windSources;
    private static Map<Block, Predicate<BlockState>> windSourcesParsed;
    private static ForgeConfigSpec.DoubleValue paraglidingSpeed;
    private static ForgeConfigSpec.IntValue paragliderDurability;
    private static ForgeConfigSpec.BooleanValue enderDragonDropsHeartContainer;
    private static ForgeConfigSpec.BooleanValue raidGivesHeartContainer;
    private static ForgeConfigSpec.IntValue startingHearts;
    private static ForgeConfigSpec.IntValue maxHeartContainers;
    private static ForgeConfigSpec.IntValue maxStamina;
    private static ForgeConfigSpec.IntValue startingStamina;
    private static ForgeConfigSpec.IntValue maxStaminaVessels;
    private static ForgeConfigSpec.BooleanValue debugPlayerMovement;
    private static ForgeConfigSpec.BooleanValue traceMovementPacket;
    private static ForgeConfigSpec.BooleanValue traceParaglidingPacket;
    private static ForgeConfigSpec.BooleanValue traceVesselPacket;
    private static final Pattern REGEX;

    private ModCfg() {
    }

    public static boolean ascendingWinds() {
        return (Boolean)ascendingWinds.get();
    }

    public static boolean paraglidingConsumesStamina() {
        return (Boolean)paraglidingConsumesStamina.get();
    }

    public static boolean runningConsumesStamina() {
        return (Boolean)runningConsumesStamina.get();
    }

    public static boolean isWindSource(BlockState state) {
        Predicate<BlockState> p = windSourcesParsed.get(state.func_177230_c());
        return p != null && p.test(state);
    }

    public static double paraglidingSpeed() {
        return (Double)paraglidingSpeed.get();
    }

    public static int paragliderDurability() {
        return (Integer)paragliderDurability.get();
    }

    public static boolean enderDragonDropsHeartContainer() {
        return (Boolean)enderDragonDropsHeartContainer.get();
    }

    public static boolean raidGivesHeartContainer() {
        return (Boolean)raidGivesHeartContainer.get();
    }

    public static int startingHearts() {
        return (Integer)startingHearts.get();
    }

    public static int maxHeartContainers() {
        return (Integer)maxHeartContainers.get();
    }

    public static int maxStamina() {
        return (Integer)maxStamina.get();
    }

    public static int startingStamina() {
        return Math.min(ModCfg.maxStamina(), (Integer)startingStamina.get());
    }

    public static int maxStaminaVessels() {
        return (Integer)maxStaminaVessels.get();
    }

    public static int maxStamina(int staminaVessels) {
        int maxStaminaVessels = ModCfg.maxStaminaVessels();
        int startingStamina = ModCfg.startingStamina();
        if (maxStaminaVessels <= 0) {
            return startingStamina;
        }
        if (maxStaminaVessels <= staminaVessels) {
            ModCfg.maxStamina();
        }
        return startingStamina + (int)((double)staminaVessels / (double)maxStaminaVessels * (double)(ModCfg.maxStamina() - startingStamina));
    }

    public static boolean debugPlayerMovement() {
        return (Boolean)debugPlayerMovement.get();
    }

    public static boolean traceMovementPacket() {
        return (Boolean)traceMovementPacket.get();
    }

    public static boolean traceParaglidingPacket() {
        return (Boolean)traceParaglidingPacket.get();
    }

    public static boolean traceVesselPacket() {
        return (Boolean)traceVesselPacket.get();
    }

    public static void init() {
        ForgeConfigSpec.Builder server = new ForgeConfigSpec.Builder();
        ascendingWinds = server.comment("Fire will float you upward.").define("ascendingWinds", true);
        windSources = server.comment("You can customize which block produces wind.\nWrite each blockstate to one of this format:\n  [block ID]   (Matches all state of the block)\n  [block ID]#[property1=value],[property2=value],[property3=value]   (Matches state of the block that has specified properties)\nSame property cannot be specified multiple times. Wind sources with any invalid part will be excluded.").defineListAllowEmpty(Collections.singletonList("windSources"), () -> ImmutableList.of((Object)"fire", (Object)"campfire#lit=true", (Object)"soul_campfire#lit=true"), o -> true);
        paraglidingSpeed = server.comment("Horizontal movement speed while paragliding.").defineInRange("paraglidingSpeed", 1.0, 0.2, 10.0);
        paragliderDurability = server.comment("Durability of Paragliders. Set to zero to disable durability.").defineInRange("paragliderDurability", 0, 0, Integer.MAX_VALUE);
        server.push("spiritOrbs");
        enderDragonDropsHeartContainer = server.comment("If true, Ender Dragon will drop heart container upon death.").define("enderDragonDropsHeartContainer", true);
        raidGivesHeartContainer = server.comment("If true, Raids will give heart container upon victory.").define("raidGivesHeartContainer", true);
        server.pop();
        server.push("vessels");
        startingHearts = server.comment("Starting health points.").defineInRange("startingHearts", 10, 1, 512);
        maxHeartContainers = server.comment("Maximum amount of Heart Containers one player can consume.\nDo note that the maximum health point is capped at 1024 (512 hearts).").defineInRange("maxHeartContainers", 20, 0, 512);
        maxStamina = server.comment("Maximum amount of stamina Player can get. Do note that one third of this value is equal to one stamina wheel.").defineInRange("maxStamina", 3000, 0, Integer.MAX_VALUE);
        startingStamina = server.comment("Amount of stamina Player starts with. Values higher than maxStamina doesn't work.\nIf you want to make this value displayed as exactly one stamina wheel, you have to make this value one third of maxStamina.").defineInRange("startingStamina", 1000, 0, Integer.MAX_VALUE);
        maxStaminaVessels = server.comment("Stamina Vessels players need to obtain max out stamina. More vessels means lesser stamina increase per vessel.").defineInRange("maxStaminaVessels", 10, 0, Integer.MAX_VALUE);
        server.pop();
        server.push("stamina");
        paraglidingConsumesStamina = server.comment("Paragliding and ascending will consume stamina.").define("paraglidingConsumesStamina", true);
        runningConsumesStamina = server.comment("Actions other than paragliding or ascending will consume stamina.").define("runningAndSwimmingConsumesStamina", false);
        server.push("consumptions");
        for (PlayerState state : PlayerState.values()) {
            state.setConfig(server.defineInRange(state.id + "StaminaConsumption", state.defaultChange, Integer.MIN_VALUE, Integer.MAX_VALUE));
        }
        server.pop();
        server.pop();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, server.build());
        ForgeConfigSpec.Builder common = new ForgeConfigSpec.Builder();
        common.push("debug");
        debugPlayerMovement = common.define("debugPlayerMovement", false);
        traceMovementPacket = common.define("traceMovementPacket", false);
        traceParaglidingPacket = common.define("traceParaglidingPacket", false);
        traceVesselPacket = common.define("traceVesselPacket", false);
        common.pop();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, common.build());
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading event) {
        ModConfig cfg = event.getConfig();
        if (cfg.getModId().equals("paraglider") && cfg.getType() == ModConfig.Type.SERVER) {
            windSourcesParsed = Collections.unmodifiableMap(ModCfg.parseWindSources());
        }
    }

    @SubscribeEvent
    public static void onReload(ModConfig.Reloading event) {
        MinecraftServer server;
        ModConfig cfg = event.getConfig();
        if (cfg.getModId().equals("paraglider") && cfg.getType() == ModConfig.Type.SERVER && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            server.execute(() -> {
                windSourcesParsed = Collections.unmodifiableMap(ModCfg.parseWindSources());
            });
        }
    }

    private static Map<Block, Predicate<BlockState>> parseWindSources() {
        IdentityHashMap<Block, Predicate<BlockState>> map = new IdentityHashMap<Block, Predicate<BlockState>>();
        Matcher m = REGEX.matcher("");
        for (String s : (List)windSources.get()) {
            if (!m.reset(s).matches()) {
                ModCfg.warnIgnoredWindSource(s, "input pattern is incorrect", new Object[0]);
                continue;
            }
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(m.group(1)));
            if (block == null || block == Blocks.field_150350_a) {
                ModCfg.warnIgnoredWindSource(s, "no such block exists", new Object[0]);
                continue;
            }
            Predicate<BlockState> p = ModCfg.parsePredicate(s, m, block);
            if (p == null) continue;
            map.compute(block, (k, v) -> v == null ? p : v.or(p));
        }
        return map;
    }

    @Nullable
    private static Predicate<BlockState> parsePredicate(String input, Matcher matcher, Block block) {
        String blockState = matcher.group(2);
        if (blockState == null) {
            return s -> true;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String s2 : blockState.split(",")) {
            int i = s2.indexOf(61);
            String key = s2.substring(0, i);
            if (properties.containsKey(key)) {
                ModCfg.warnIgnoredWindSource(input, "same property '{}' was defined twice", key);
                return null;
            }
            properties.put(key, s2.substring(i + 1));
        }
        IdentityHashMap parsedProperties = new IdentityHashMap();
        for (Map.Entry e : properties.entrySet()) {
            String key = (String)e.getKey();
            Property property = block.func_176194_O().func_185920_a(key);
            if (property == null) {
                ModCfg.warnIgnoredWindSource(input, "property '{}' doesn't exist on that block", key);
                return null;
            }
            if (parsedProperties.containsKey(property)) {
                ModCfg.warnIgnoredWindSource(input, "same property '{}' was defined twice", key);
                return null;
            }
            Optional o2 = property.func_185929_b((String)e.getValue());
            if (!o2.isPresent()) {
                ModCfg.warnIgnoredWindSource(input, "property '{}' doesn't contain value '{}'", key, e.getValue());
                return null;
            }
            parsedProperties.put(property, o2.get());
        }
        BlockStateMatcher m = BlockStateMatcher.func_177638_a((Block)block);
        for (Map.Entry e : parsedProperties.entrySet()) {
            Object v = e.getValue();
            m.func_201028_a((Property)e.getKey(), o -> o != null && o.equals(v));
        }
        return m;
    }

    private static void warnIgnoredWindSource(String input, String cause, Object ... args) {
        ParagliderMod.LOGGER.warn("Wind source '" + input + "' was ignored, because " + cause, args);
    }

    static {
        REGEX = Pattern.compile("^((?:[a-z0-9_.-]+:)?[a-z0-9_.-]+)(?:\\s*#\\s*([A-Za-z0-9_.-]+\\s*=\\s*[A-Za-z0-9_.-]+(?:\\s*,\\s*[A-Za-z0-9_.-]+\\s*=\\s*[A-Za-z0-9_.-]+)*))?$");
    }
}

