/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.capabilities;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.network.PacketDistributor;
import tictim.paraglider.ModCfg;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.capabilities.Paraglider;
import tictim.paraglider.capabilities.PlayerMovement;
import tictim.paraglider.capabilities.PlayerState;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.contents.ModAdvancements;
import tictim.paraglider.item.ParagliderItem;
import tictim.paraglider.network.ModNet;
import tictim.paraglider.network.SyncMovementMsg;
import tictim.paraglider.network.SyncParaglidingMsg;
import tictim.paraglider.network.SyncVesselMsg;
import tictim.paraglider.utils.WindUtils;

public final class ServerPlayerMovement
extends PlayerMovement
implements INBTSerializable<CompoundNBT> {
    public static final int PANIC_INITIAL_DELAY = 10;
    public static final int PANIC_DELAY = 30;
    public static final int PANIC_DURATION = 15;
    public static final UUID HEART_CONTAINER_UUID = UUID.fromString("a0f1c25b-c4f9-4413-9619-7841cd7982a3");
    private final ServerPlayerEntity serverPlayer;
    private PlayerState prevState = PlayerState.IDLE;
    private boolean healthNeedsUpdate;
    private boolean prevIsParagliding;
    public boolean vesselNeedsSync;
    public boolean movementNeedsSync;
    public boolean paraglidingNeedsSync;
    private double prevY;
    private double accumulatedFallDistance;
    private int panicParaglidingDelay = 10;
    private int panicParaglidingDuration = 0;
    private int essence;

    public ServerPlayerMovement(ServerPlayerEntity player) {
        super((PlayerEntity)player);
        this.serverPlayer = player;
    }

    public int getEssence() {
        return this.essence;
    }

    public void setEssence(int essence) {
        this.essence = Math.max(essence, 0);
    }

    @Override
    public void setStaminaVessels(int staminaVessels) {
        int cache = this.getStaminaVessels();
        super.setStaminaVessels(staminaVessels);
        if (cache != staminaVessels) {
            this.vesselNeedsSync = true;
        }
    }

    @Override
    public void setHeartContainers(int heartContainers) {
        int cache = this.getHeartContainers();
        super.setHeartContainers(heartContainers);
        if (cache != heartContainers) {
            this.vesselNeedsSync = true;
        }
        this.healthNeedsUpdate = true;
    }

    @Override
    public boolean isParagliding() {
        return this.prevIsParagliding;
    }

    @Override
    public void update() {
        boolean isParagliding;
        if (this.healthNeedsUpdate) {
            ModifiableAttributeInstance attrib = this.player.func_110148_a(Attributes.field_233818_a_);
            if (attrib != null) {
                attrib.func_188479_b(HEART_CONTAINER_UUID);
                int heart = ModCfg.startingHearts() - 10 + Math.min(ModCfg.maxHeartContainers(), this.getHeartContainers());
                if (heart != 0) {
                    attrib.func_233769_c_(new AttributeModifier(HEART_CONTAINER_UUID, () -> "Heart Containers", (double)(heart * 2), AttributeModifier.Operation.ADDITION));
                }
                double mhp = attrib.func_111126_e();
                if ((double)this.player.func_110143_aJ() > mhp) {
                    this.player.func_70606_j((float)mhp);
                }
            }
            this.healthNeedsUpdate = false;
        }
        this.accumulatedFallDistance = this.player.func_233570_aj_() || this.player.func_226278_cu_() > this.prevY ? 0.0 : (this.accumulatedFallDistance += this.prevY - this.player.func_226278_cu_());
        boolean isHoldingParaglider = Paraglider.isParaglider(this.player.func_184614_ca());
        this.setState(this.calculatePlayerState(isHoldingParaglider));
        if (this.prevState != this.getState()) {
            this.movementNeedsSync = true;
        }
        this.updateStamina();
        boolean bl = isParagliding = this.getState().isParagliding() && (this.canUseParaglider() || this.tryPanicParagliding());
        if (this.prevIsParagliding != isParagliding) {
            this.paraglidingNeedsSync = true;
            this.prevIsParagliding = isParagliding;
        }
        if (!this.player.field_71075_bZ.field_75098_d && this.isDepleted()) {
            this.player.func_195064_c(new EffectInstance((Effect)Contents.EXHAUSTED.get(), 2, 0, false, false, false));
        }
        this.applyMovement();
        if (this.movementNeedsSync) {
            SyncMovementMsg msg = new SyncMovementMsg(this);
            if (ModCfg.traceMovementPacket()) {
                ParagliderMod.LOGGER.debug("Sending packet {} to player {}", (Object)msg, (Object)this.player);
            }
            ModNet.NET.send(PacketDistributor.PLAYER.with(() -> this.serverPlayer), (Object)msg);
            this.paraglidingNeedsSync = true;
            this.movementNeedsSync = false;
        }
        if (this.paraglidingNeedsSync) {
            SyncParaglidingMsg msg2 = new SyncParaglidingMsg(this);
            if (ModCfg.traceParaglidingPacket()) {
                ParagliderMod.LOGGER.debug("Sending packet {} to player tracking {}", (Object)msg2, (Object)this.player);
            }
            ModNet.NET.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this.serverPlayer), (Object)msg2);
            this.paraglidingNeedsSync = false;
        }
        if (this.vesselNeedsSync) {
            SyncVesselMsg msg = new SyncVesselMsg(this.getStamina(), this.getHeartContainers(), this.getStaminaVessels());
            if (ModCfg.traceVesselPacket()) {
                ParagliderMod.LOGGER.debug("Sending packet {} to player {}", (Object)msg, (Object)this.player);
            }
            ModNet.NET.send(PacketDistributor.PLAYER.with(() -> this.serverPlayer), (Object)msg);
            if (ModCfg.maxHeartContainers() <= this.getHeartContainers() && ModCfg.maxStaminaVessels() <= this.getStaminaVessels()) {
                ModAdvancements.give(this.serverPlayer, ModAdvancements.ALL_VESSELS, "code_triggered");
            }
            this.vesselNeedsSync = false;
        }
        this.prevState = this.getState();
        this.prevY = this.player.func_226278_cu_();
        for (int i = 0; i < this.player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = this.player.field_71071_by.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof ParagliderItem)) continue;
            ParagliderItem.setItemParagliding(stack, i == this.player.field_71071_by.field_70461_c && isParagliding);
        }
    }

    private PlayerState calculatePlayerState(boolean isHoldingParaglider) {
        if (this.player.field_71075_bZ.field_75100_b) {
            return PlayerState.IDLE;
        }
        if (this.player.func_184187_bx() != null) {
            return PlayerState.RIDING;
        }
        if (this.player.func_203007_ba()) {
            return PlayerState.SWIMMING;
        }
        if (this.player.func_70090_H()) {
            return this.canBreathe() ? PlayerState.BREATHING_UNDERWATER : PlayerState.UNDERWATER;
        }
        if (!this.player.func_233570_aj_() && isHoldingParaglider && !this.player.func_184613_cA()) {
            if (ModCfg.ascendingWinds() && WindUtils.isInsideWind(this.player.field_70170_p, this.player.func_174813_aQ())) {
                return PlayerState.ASCENDING;
            }
            if (this.prevState.isParagliding() || this.accumulatedFallDistance >= (double)1.45f) {
                return PlayerState.PARAGLIDING;
            }
        }
        if (this.player.func_70051_ag() && !this.player.func_184587_cr()) {
            return PlayerState.RUNNING;
        }
        if (this.player.func_233570_aj_()) {
            return PlayerState.IDLE;
        }
        return PlayerState.MIDAIR;
    }

    private boolean canBreathe() {
        ItemStack feet;
        if (this.player.func_70644_a(Effects.field_76427_o)) {
            return true;
        }
        if (this.player.func_233570_aj_() && (!this.player.func_208600_a((ITag)FluidTags.field_206959_a) || this.player.field_70170_p.func_180495_p(new BlockPos(this.player.func_226277_ct_(), this.player.func_226280_cw_(), this.player.func_226281_cx_())).func_203425_a(Blocks.field_203203_C))) {
            return true;
        }
        ItemStack head = this.player.func_184582_a(EquipmentSlotType.HEAD);
        if (!head.func_190926_b()) {
            if (head.func_77973_b() == Items.field_203179_ao) {
                return true;
            }
            if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185299_g, (ItemStack)head) > 0) {
                return true;
            }
        }
        return !(feet = this.player.func_184582_a(EquipmentSlotType.FEET)).func_190926_b() && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185300_i, (ItemStack)feet) > 0;
    }

    @Override
    protected void applyMovement() {
        super.applyMovement();
        if (this.isParagliding()) {
            this.serverPlayer.field_71135_a.field_147365_f = 0;
            ItemStack stack = this.player.func_184614_ca();
            if (Paraglider.isParaglider(stack)) {
                ServerPlayerMovement.damageParagliderWithoutBreaking(this.player, stack);
            }
        }
    }

    private static void damageParagliderWithoutBreaking(PlayerEntity player, ItemStack stack) {
        AtomicBoolean fuck = new AtomicBoolean();
        int count = stack.func_190916_E();
        stack.func_222118_a(1, (LivingEntity)player, p -> {
            p.func_213334_d(Hand.MAIN_HAND);
            stack.func_190920_e(count + 1);
            fuck.set(true);
        });
        if (fuck.get()) {
            stack.func_190920_e(count);
            stack.func_196085_b(stack.func_77958_k());
        }
    }

    @Override
    protected void updateStamina() {
        boolean wasDepleted = this.isDepleted();
        super.updateStamina();
        if (this.isDepleted() != wasDepleted) {
            this.movementNeedsSync = true;
        }
        if (this.isDepleted()) {
            if (this.getStamina() >= this.getMaxStamina()) {
                this.setDepleted(false);
                this.movementNeedsSync = true;
            }
        } else if (this.getStamina() <= 0) {
            this.setDepleted(true);
            this.panicParaglidingDelay = 10;
            this.movementNeedsSync = true;
        }
    }

    private boolean tryPanicParagliding() {
        if (this.panicParaglidingDuration > 0) {
            --this.panicParaglidingDuration;
            return true;
        }
        if (this.panicParaglidingDelay > 0) {
            --this.panicParaglidingDelay;
            return false;
        }
        this.panicParaglidingDelay = 30;
        this.panicParaglidingDuration = 15;
        return true;
    }

    @Override
    public void copyTo(PlayerMovement another) {
        super.copyTo(another);
        if (another instanceof ServerPlayerMovement) {
            ((ServerPlayerMovement)another).setEssence(this.getEssence());
        }
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("stamina", this.getStamina());
        nbt.func_74757_a("depleted", this.isDepleted());
        nbt.func_74768_a("recoveryDelay", this.getRecoveryDelay());
        nbt.func_74768_a("panicParaglidingDelay", this.panicParaglidingDelay);
        nbt.func_74768_a("staminaVessels", this.getStaminaVessels());
        nbt.func_74768_a("heartContainers", this.getHeartContainers());
        nbt.func_74768_a("essence", this.getEssence());
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.setStamina(nbt.func_74762_e("stamina"));
        this.setDepleted(nbt.func_74767_n("depleted"));
        this.setRecoveryDelay(nbt.func_74762_e("recoveryDelay"));
        this.panicParaglidingDelay = nbt.func_74762_e("panicParaglidingDelay");
        this.setStaminaVessels(nbt.func_74762_e("staminaVessels"));
        this.setHeartContainers(nbt.func_74762_e("heartContainers"));
        this.setEssence(nbt.func_74762_e("essence"));
    }

    @Nullable
    public static ServerPlayerMovement of(ICapabilityProvider capabilityProvider) {
        PlayerMovement movement = PlayerMovement.of(capabilityProvider);
        return movement instanceof ServerPlayerMovement ? (ServerPlayerMovement)movement : null;
    }
}

