/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.client;

import tictim.paraglider.utils.Color;

public final class StaminaWheelConstants {
    public static final Color IDLE = Color.of(0, 223, 83);
    public static final Color GLOW = Color.of(255, 255, 255);
    public static final Color EVIL_GLOW = Color.of(248, 223, 223);
    public static final Color TRANSPARENT = Color.of(255, 255, 255, 0);
    public static final Color DEPLETED_1 = Color.of(150, 2, 2);
    public static final Color DEPLETED_2 = Color.of(255, 150, 2);
    public static final Color EMPTY = Color.of(2, 2, 2, 150);
    public static final long GLOW_FADE_START = 100L;
    public static final long GLOW_FADE = 250L;
    public static final long FADE_START = 1000L;
    public static final long FADE = 100L;
    public static final long BLINK = 300L;
    public static final long DEPLETED_BLINK = 600L;
    public static final double WHEEL_SIZE = 10.0;

    private StaminaWheelConstants() {
    }

    public static Color getGlowAndFadeColor(long time) {
        if (time < 100L) {
            return GLOW;
        }
        if (time < 350L) {
            return GLOW.blend(IDLE, (float)(time - 100L) / 250.0f);
        }
        if (time < 1000L) {
            return IDLE;
        }
        if (time < 1100L) {
            return IDLE.blend(TRANSPARENT, (float)(time - 1000L) / 100.0f);
        }
        return TRANSPARENT;
    }

    public static float cycle(long currentTime, long cycleTime) {
        long halfCycle = cycleTime / 2L;
        return (float)Math.abs(currentTime % cycleTime - halfCycle) / (float)halfCycle;
    }
}

