/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tictim.paraglider.ModCfg;
import tictim.paraglider.capabilities.Paraglider;
import tictim.paraglider.capabilities.PlayerMovement;
import tictim.paraglider.utils.Color;

public abstract class StaminaWheelRenderer {
    private final Map<WheelLevel, Wheel> wheel = new EnumMap<WheelLevel, Wheel>(WheelLevel.class);

    public void renderStamina(MatrixStack matrixStack, double x, double y, double z) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        PlayerMovement h = PlayerMovement.of((ICapabilityProvider)player);
        if (h == null) {
            return;
        }
        this.makeWheel(h);
        this.render(matrixStack, x, y, z, ModCfg.debugPlayerMovement() && player.func_184592_cb().getCapability(Paraglider.CAP).isPresent());
    }

    protected abstract void makeWheel(PlayerMovement var1);

    @Nullable
    protected Wheel getWheel(WheelLevel type) {
        return this.wheel.get((Object)type);
    }

    protected void addWheel(WheelLevel wheelLevel, double start, double end, Color color) {
        if ((start = Math.max(0.0, start)) >= (end = Math.min(1.0, end))) {
            return;
        }
        Wheel wheel = this.wheel.get((Object)wheelLevel);
        this.wheel.put(wheelLevel, wheel != null ? wheel.insert(new Wheel(start, end, color)) : new Wheel(start, end, color));
    }

    protected void render(MatrixStack stack, double x, double y, double z, boolean debug) {
        RenderSystem.disableDepthTest();
        BufferBuilder b = Tessellator.func_178181_a().func_178180_c();
        Minecraft mc = Minecraft.func_71410_x();
        if (debug) {
            float linePos = 10.0f;
            FontRenderer font = mc.field_71466_p;
            for (WheelLevel t : WheelLevel.values()) {
                Wheel wheel = this.getWheel(t);
                if (wheel == null) continue;
                linePos = font.func_238405_a_(stack, (Object)((Object)t) + ":", 20.0f, linePos, -1);
                linePos = font.func_238405_a_(stack, wheel.toString(), 30.0f, linePos, -1);
            }
        }
        for (WheelLevel t : WheelLevel.values()) {
            Wheel wheel = this.getWheel(t);
            if (wheel == null) continue;
            mc.func_110434_K().func_110577_a(t.texture);
            RenderSystem.enableAlphaTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            wheel.draw(stack, b, x, y, z, 10.0, debug);
        }
        RenderSystem.enableDepthTest();
        this.wheel.clear();
    }

    public static enum WheelLevel {
        FIRST(new ResourceLocation("paraglider", "textures/stamina/first.png")),
        SECOND(new ResourceLocation("paraglider", "textures/stamina/second.png")),
        THIRD(new ResourceLocation("paraglider", "textures/stamina/third.png"));

        public final ResourceLocation texture;

        private WheelLevel(ResourceLocation texture) {
            this.texture = Objects.requireNonNull(texture);
        }

        private int start() {
            return ModCfg.startingStamina() * this.ordinal();
        }

        private int end() {
            return ModCfg.startingStamina() * (1 + this.ordinal());
        }

        public double getProportion(int value) {
            int start = this.start();
            if (start >= value) {
                return 0.0;
            }
            int end = this.end();
            if (end <= value) {
                return 1.0;
            }
            return (double)(value - start) / (double)(end - start);
        }
    }

    public static final class Wheel {
        private double start;
        private double end;
        private final Color color;
        @Nullable
        private Wheel next;
        private static final double[] renderPoints = new double[]{0.0, 0.125, 0.375, 0.625, 0.875, 1.0};

        private Wheel(double start, double end, Color color) {
            this.start = start;
            this.end = end;
            this.color = Objects.requireNonNull(color);
        }

        public Wheel insert(Wheel wheel) {
            return this.insert(wheel, true);
        }

        private Wheel insert(Wheel wheel, boolean overwrite) {
            if (wheel.start <= this.start) {
                if (wheel.end >= this.end) {
                    return this.next != null ? wheel.insert(this.next, false) : wheel;
                }
                this.start = wheel.end;
                wheel.next = this;
                return wheel;
            }
            if (overwrite && wheel.start < this.end) {
                this.end = wheel.start;
            }
            this.next = this.next != null ? this.next.insert(wheel, overwrite) : wheel;
            return this;
        }

        public void draw(MatrixStack stack, BufferBuilder b, double x, double y, double z, double size, boolean debug) {
            ArrayList<Vector2f> debugVertices = debug ? new ArrayList<Vector2f>() : null;
            b.func_181668_a(6, DefaultVertexFormats.field_227851_o_);
            b.func_225582_a_(x, y, z).func_227885_a_(this.color.red, this.color.green, this.color.blue, this.color.alpha).func_225583_a_(0.5f, 0.5f).func_181675_d();
            this.drawInternal(b, x, y, z, size, debugVertices, false);
            b.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)b);
            if (debugVertices != null) {
                stack.func_227860_a_();
                stack.func_227861_a_(x, y, z);
                FontRenderer font = Minecraft.func_71410_x().field_71466_p;
                for (Vector2f vec : debugVertices) {
                    float f;
                    String s = vec.field_189982_i + " " + vec.field_189983_j;
                    float f2 = vec.field_189982_i > 0.0f ? vec.field_189982_i * (float)size + 2.0f : vec.field_189982_i * (float)size - 2.0f - (float)font.func_78256_a(s);
                    if (vec.field_189983_j > 0.0f) {
                        float f3 = vec.field_189983_j * (float)(-size) - 2.0f;
                        font.getClass();
                        f = f3 - 9.0f;
                    } else {
                        f = vec.field_189983_j * (float)(-size) + 2.0f;
                    }
                    font.func_238405_a_(stack, s, f2, f, -16711936);
                }
                stack.func_227865_b_();
            }
        }

        private void drawInternal(BufferBuilder b, double x, double y, double z, double size, @Nullable List<Vector2f> debugVertices, boolean skipFirst) {
            double currentStart;
            for (int i = 0; i < renderPoints.length - 1 && !((currentStart = renderPoints[i]) >= this.end); ++i) {
                double currentEnd = renderPoints[i + 1];
                if (currentEnd <= this.start) continue;
                if (currentStart <= this.start && !skipFirst) {
                    this.vert(b, x, y, z, this.start, size, debugVertices);
                }
                this.vert(b, x, y, z, Math.min(currentEnd, this.end), size, debugVertices);
            }
            if (this.next != null) {
                this.next.drawInternal(b, x, y, z, size, debugVertices, this.end == this.next.start);
            }
        }

        private void vert(BufferBuilder b, double x, double y, double z, double point, double size, @Nullable List<Vector2f> debugVertices) {
            double vy;
            double vx;
            if (point == 0.0 || point == 1.0) {
                vx = 0.0;
                vy = 1.0;
            } else if (point == 0.125) {
                vx = -1.0;
                vy = 1.0;
            } else if (point == 0.375) {
                vx = -1.0;
                vy = -1.0;
            } else if (point == 0.625) {
                vx = 1.0;
                vy = -1.0;
            } else if (point == 0.875) {
                vx = 1.0;
                vy = 1.0;
            } else if (point < 0.125 || point > 0.875) {
                vx = -Math.tan(point * (Math.PI * 2));
                vy = 1.0;
            } else if (point < 0.375) {
                vx = -1.0;
                vy = 1.0 / Math.tan(point * (Math.PI * 2));
            } else if (point < 0.625) {
                vx = Math.tan(point * (Math.PI * 2));
                vy = -1.0;
            } else {
                vx = 1.0;
                vy = -1.0 / Math.tan(point * (Math.PI * 2));
            }
            b.func_225582_a_(x + vx * size, y + vy * -size, z).func_227885_a_(this.color.red, this.color.green, this.color.blue, this.color.alpha).func_225583_a_((float)(vx / 2.0 + 0.5), (float)(vy / 2.0 + 0.5)).func_181675_d();
            if (debugVertices != null) {
                debugVertices.add(new Vector2f((float)vx, (float)vy));
            }
        }

        public String toString() {
            return this.next != null ? String.format("[%f ~ %f](#%s) -> \n%s", this.start, this.end, this.color, this.next) : String.format("[%f ~ %f](#%s)", this.start, this.end, this.color);
        }
    }
}

