/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import tictim.paraglider.contents.worldgen.NetherHornedStatuePiece;
import tictim.paraglider.contents.worldgen.NetherHornedStatueStructure;
import tictim.paraglider.contents.worldgen.TarreyTownGoddessStatuePiece;
import tictim.paraglider.contents.worldgen.TarreyTownGoddessStatueStructure;
import tictim.paraglider.contents.worldgen.UndergroundHornedStatuePiece;
import tictim.paraglider.contents.worldgen.UndergroundHornedStatueStructure;

@Mod.EventBusSubscriber(modid="paraglider", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ModStructures {
    public static final UndergroundHornedStatueStructure UNDERGROUND_HORNED_STATUE = new UndergroundHornedStatueStructure();
    public static final IStructurePieceType UNDERGROUND_HORNED_STATUE_PIECE_TYPE = UndergroundHornedStatuePiece::new;
    public static final StructureFeature<?, ?> UNDERGROUND_HORNED_STATUE_CONFIGURED = UNDERGROUND_HORNED_STATUE.func_236391_a_((IFeatureConfig)NoFeatureConfig.field_202429_e);
    public static final StructureSeparationSettings UNDERGROUND_HORNED_STATUE_SEPARATION_SETTINGS = new StructureSeparationSettings(32, 8, 49788929);
    public static final NetherHornedStatueStructure NETHER_HORNED_STATUE = new NetherHornedStatueStructure();
    public static final IStructurePieceType NETHER_HORNED_STATUE_PIECE_TYPE = NetherHornedStatuePiece::new;
    public static final StructureFeature<?, ?> NETHER_HORNED_STATUE_CONFIGURED = NETHER_HORNED_STATUE.func_236391_a_((IFeatureConfig)NoFeatureConfig.field_202429_e);
    public static final StructureSeparationSettings NETHER_HORNED_STATUE_SEPARATION_SETTINGS = new StructureSeparationSettings(64, 8, 1973135446);
    public static final TarreyTownGoddessStatueStructure TARREY_TOWN_GODDESS_STATUE = new TarreyTownGoddessStatueStructure();
    public static final IStructurePieceType TARREY_TOWN_GODDESS_STATUE_PIECE_TYPE = TarreyTownGoddessStatuePiece::new;
    public static final StructureFeature<?, ?> TARREY_TOWN_GODDESS_STATUE_CONFIGURED = TARREY_TOWN_GODDESS_STATUE.func_236391_a_((IFeatureConfig)NoFeatureConfig.field_202429_e);
    public static final StructureSeparationSettings TARREY_TOWN_GODDESS_STATUE_SEPARATION_SETTINGS = new StructureSeparationSettings(64, 8, 850796625);

    private ModStructures() {
    }

    @SubscribeEvent
    public static void registerStructure(RegistryEvent.Register<Structure<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        ModStructures.register(registry, UNDERGROUND_HORNED_STATUE, UNDERGROUND_HORNED_STATUE_PIECE_TYPE, UNDERGROUND_HORNED_STATUE_CONFIGURED, UNDERGROUND_HORNED_STATUE_SEPARATION_SETTINGS, "underground_horned_statue");
        ModStructures.register(registry, NETHER_HORNED_STATUE, NETHER_HORNED_STATUE_PIECE_TYPE, NETHER_HORNED_STATUE_CONFIGURED, NETHER_HORNED_STATUE_SEPARATION_SETTINGS, "nether_horned_statue");
        ModStructures.register(registry, TARREY_TOWN_GODDESS_STATUE, TARREY_TOWN_GODDESS_STATUE_PIECE_TYPE, TARREY_TOWN_GODDESS_STATUE_CONFIGURED, TARREY_TOWN_GODDESS_STATUE_SEPARATION_SETTINGS, "tarrey_town_goddess_statue");
    }

    private static void register(IForgeRegistry<Structure<?>> registry, Structure<?> structure, IStructurePieceType structurePieceType, StructureFeature<?, ?> structureFeature, StructureSeparationSettings separationSettings, String structureName) {
        ResourceLocation key = new ResourceLocation("paraglider", structureName);
        registry.register(structure.setRegistryName(key));
        Structure.field_236365_a_.put((Object)key.toString(), structure);
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)separationSettings).build();
        Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)key, (Object)structurePieceType);
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)key, structureFeature);
        FlatGenerationSettings.field_202247_j.put(structure, structureFeature);
    }
}

