/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.datagen;

import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.EntityHasProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.KilledByPlayer;
import net.minecraft.loot.conditions.RandomChance;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootTableIdCondition;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.loot.ItemModifier;
import tictim.paraglider.loot.ParagliderModifier;

public class LootModifierProvider
extends GlobalLootModifierProvider {
    public LootModifierProvider(DataGenerator gen, String modid) {
        super(gen, modid);
    }

    protected void start() {
        this.add("towers_of_the_wild/chest", (GlobalLootModifierSerializer)Contents.PARAGLIDER_MODIFIER.get(), (IGlobalLootModifier)new ParagliderModifier(new ILootCondition[]{LootTableIdCondition.builder((ResourceLocation)new ResourceLocation("towers_of_the_wild", "chests/tower/regular/tower_chest")).build()}));
        this.add("towers_of_the_wild/ocean_chest", (GlobalLootModifierSerializer)Contents.PARAGLIDER_MODIFIER.get(), (IGlobalLootModifier)new ParagliderModifier(new ILootCondition[]{LootTableIdCondition.builder((ResourceLocation)new ResourceLocation("towers_of_the_wild", "chests/tower/ocean/ocean_tower_chest")).build()}, true));
        this.addSpiritOrbItemModifier("wither", new ItemModifier(new ILootCondition[]{EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_203998_a(EntityType.field_200760_az)).build(), KilledByPlayer.func_215994_b().build()}, (Item)Contents.SPIRIT_ORB.get(), 1));
        this.addSpiritOrbItemModifier("spawner", new ItemModifier(new ILootCondition[]{BlockStateProperty.func_215985_a((Block)Blocks.field_150474_ac).build()}, (Item)Contents.SPIRIT_ORB.get(), 1));
        this.addChestSpiritOrbItemModifier("underwater_ruin_big", 0.5f);
        this.addChestSpiritOrbItemModifier("underwater_ruin_small", 0.5f);
        this.addChestSpiritOrbItemModifier("jungle_temple");
        this.addChestSpiritOrbItemModifier("desert_pyramid", 0.5f);
        this.addChestSpiritOrbItemModifier("bastion_other");
        this.addChestSpiritOrbItemModifier("bastion_bridge");
        this.addChestSpiritOrbItemModifier("bastion_treasure");
        this.addChestSpiritOrbItemModifier("bastion_hoglin_stable");
        this.addChestSpiritOrbItemModifier("stronghold_corridor", 0.5f);
        this.addChestSpiritOrbItemModifier("stronghold_crossing", 0.5f);
        this.addChestSpiritOrbItemModifier("stronghold_library");
        this.addChestSpiritOrbItemModifier("nether_bridge", 0.5f);
        this.addChestSpiritOrbItemModifier("buried_treasure");
    }

    private void addChestSpiritOrbItemModifier(String chestLootTableName, float chance) {
        this.addSpiritOrbItemModifier(chestLootTableName, new ItemModifier(new ILootCondition[]{LootTableIdCondition.builder((ResourceLocation)new ResourceLocation("chests/" + chestLootTableName)).build(), RandomChance.func_216004_a((float)chance).build()}, (Item)Contents.SPIRIT_ORB.get(), 1));
    }

    private void addChestSpiritOrbItemModifier(String chestLootTableName) {
        this.addSpiritOrbItemModifier(chestLootTableName, new ItemModifier(new ILootCondition[]{LootTableIdCondition.builder((ResourceLocation)new ResourceLocation("chests/" + chestLootTableName)).build()}, (Item)Contents.SPIRIT_ORB.get(), 1));
    }

    private void addSpiritOrbItemModifier(String modifier, ItemModifier instance) {
        this.add("spirit_orbs/" + modifier, (GlobalLootModifierSerializer)Contents.ITEM_MODIFIER.get(), (IGlobalLootModifier)instance);
    }
}

