/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.event;

import java.util.ArrayList;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import tictim.paraglider.ModCfg;
import tictim.paraglider.capabilities.PlayerMovement;
import tictim.paraglider.client.InGameStaminaWheelRenderer;
import tictim.paraglider.client.StaminaWheelRenderer;
import tictim.paraglider.client.StatueBargainScreen;

@Mod.EventBusSubscriber(modid="paraglider", value={Dist.CLIENT})
public final class ParagliderClientEventHandler {
    private static final StaminaWheelRenderer STAMINA_WHEEL_RENDERER = new InGameStaminaWheelRenderer();

    private ParagliderClientEventHandler() {
    }

    @SubscribeEvent
    public static void onOffHandRender(RenderHandEvent event) {
        if (event.getHand() != Hand.OFF_HAND) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        PlayerMovement m = PlayerMovement.of((ICapabilityProvider)player);
        if (m != null && m.isParagliding()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onGameOverlayTextRender(RenderGameOverlayEvent.Text event) {
        PlayerMovement h;
        ClientPlayerEntity p;
        if (ModCfg.debugPlayerMovement() && (p = Minecraft.func_71410_x().field_71439_g) != null && (h = PlayerMovement.of((ICapabilityProvider)p)) != null) {
            ArrayList right = event.getRight();
            ArrayList<String> arr = new ArrayList<String>();
            arr.add("State: " + (Object)((Object)h.getState()));
            arr.add((h.isDepleted() ? TextFormatting.RED : "") + "Stamina: " + h.getStamina() + " / " + h.getMaxStamina());
            arr.add(h.getStaminaVessels() + " Stamina Vessels, " + h.getHeartContainers() + " Heart Containers");
            arr.add(h.getRecoveryDelay() + " Recovery Delay");
            arr.add("Paragliding: " + h.isParagliding());
            if (!right.isEmpty()) {
                arr.add("");
            }
            right.addAll(0, arr);
        }
    }

    @SubscribeEvent
    public static void afterGameOverlayRender(RenderGameOverlayEvent.Post event) {
        if (Minecraft.func_71410_x().field_71462_r instanceof StatueBargainScreen || event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        MainWindow window = event.getWindow();
        STAMINA_WHEEL_RENDERER.renderStamina(event.getMatrixStack(), window.func_198107_o() / 2 - 100, window.func_198087_p() / 2 - 15, 25.0);
    }

    @SubscribeEvent
    public static void beforeGameOverlayRender(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS && Minecraft.func_71410_x().field_71462_r instanceof StatueBargainScreen) {
            event.setCanceled(true);
        }
    }
}

