/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.event;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import tictim.paraglider.capabilities.wind.Wind;
import tictim.paraglider.capabilities.wind.WindChunk;
import tictim.paraglider.capabilities.wind.WindNode;

@Mod.EventBusSubscriber(modid="paraglider", value={Dist.CLIENT})
public final class WindClientEventHandler {
    private static final Random PARTICLE_RNG = new Random();

    private WindClientEventHandler() {
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        Wind wind = Wind.of((ICapabilityProvider)world);
        if (wind == null) {
            return;
        }
        for (WindChunk windChunk : wind.getWindChunks()) {
            for (WindNode node : windChunk.getAllRootNodes()) {
                do {
                    if (PARTICLE_RNG.nextInt(6) != 0) continue;
                    world.func_195589_b((IParticleData)ParticleTypes.field_197629_v, (double)node.x + PARTICLE_RNG.nextDouble(), (double)node.y + 0.5, (double)node.z + PARTICLE_RNG.nextDouble(), 0.0, 1.0, 0.0);
                } while ((node = node.next) != null);
            }
        }
    }
}

