/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.event;

import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import tictim.paraglider.capabilities.Paraglider;
import tictim.paraglider.capabilities.wind.Wind;
import tictim.paraglider.capabilities.wind.WindChunk;
import tictim.paraglider.network.ModNet;
import tictim.paraglider.network.SyncWindMsg;
import tictim.paraglider.utils.WindUpdater;

@Mod.EventBusSubscriber(modid="paraglider")
public final class WindEventHandler {
    private static final ResourceLocation WIND_KEY = new ResourceLocation("paraglider", "wind");

    private WindEventHandler() {
    }

    @SubscribeEvent
    public static void onAttachWorldCapabilities(AttachCapabilitiesEvent<World> event) {
        event.addCapability(WIND_KEY, (ICapabilityProvider)new Wind());
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        List players;
        if (event.phase != TickEvent.Phase.END || !event.side.isServer()) {
            return;
        }
        WindUpdater placer = new WindUpdater();
        long gameTime = event.world.func_82737_E();
        if (gameTime % 4L == 0L && !(players = event.world.func_217369_A()).isEmpty()) {
            for (PlayerEntity player : players) {
                if (!Paraglider.isParaglider(player.func_184614_ca())) continue;
                placer.placeAround(player);
            }
        }
        placer.checkPlacedWind(event.world);
        for (WindChunk windChunk : placer.getModifiedChunks()) {
            Chunk chunk = event.world.func_212866_a_(windChunk.getChunkPos().field_77276_a, windChunk.getChunkPos().field_77275_b);
            ModNet.NET.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)new SyncWindMsg(windChunk));
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        IWorld iWorld = event.getWorld();
        if (!(iWorld instanceof World)) {
            return;
        }
        World world = (World)iWorld;
        Wind wind = Wind.of((ICapabilityProvider)world);
        if (wind != null) {
            wind.remove(event.getChunk().func_76632_l());
        }
    }

    @SubscribeEvent
    public static void onChunkWatch(ChunkWatchEvent.Watch event) {
        ServerWorld world = event.getWorld();
        Wind wind = Wind.of((ICapabilityProvider)world);
        if (wind == null) {
            return;
        }
        ChunkPos pos = event.getPos();
        WindChunk windChunk = wind.get(pos);
        if (windChunk == null || windChunk.isEmpty()) {
            return;
        }
        Chunk chunk = world.func_212866_a_(pos.field_77276_a, pos.field_77275_b);
        ModNet.NET.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)new SyncWindMsg(windChunk));
    }
}

