/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tictim.paraglider.ModCfg;
import tictim.paraglider.capabilities.Paraglider;
import tictim.paraglider.contents.Contents;

public class ParagliderItem
extends Item
implements IDyeableArmorItem {
    private final int defaultColor;

    public ParagliderItem(int defaultColor) {
        super(new Item.Properties().func_200917_a(1).func_200916_a(Contents.GROUP));
        this.defaultColor = defaultColor;
    }

    public int getMaxDamage(ItemStack stack) {
        return ModCfg.paragliderDurability();
    }

    public boolean func_77645_m() {
        return ModCfg.paragliderDurability() > 0;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return Tags.Items.LEATHER.func_230235_a_((Object)repair.func_77973_b());
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new Paraglider();
    }

    public boolean func_179215_a(CompoundNBT nbt) {
        return super.func_179215_a(nbt);
    }

    public int func_200886_f(ItemStack stack) {
        CompoundNBT nbt = stack.func_179543_a("display");
        return nbt != null && nbt.func_150297_b("color", 99) ? nbt.func_74762_e("color") : this.defaultColor;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (stack.func_77984_f() && stack.func_77958_k() <= stack.func_77952_i()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.paraglider.paraglider_broken").func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.func_77973_b() != newStack.func_77973_b() || ParagliderItem.isItemParagliding(oldStack) != ParagliderItem.isItemParagliding(newStack);
    }

    public static boolean isItemParagliding(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        return tag != null && tag.func_74767_n("Paragliding");
    }

    public static void setItemParagliding(ItemStack stack, boolean paragliding) {
        if (ParagliderItem.isItemParagliding(stack) == paragliding) {
            return;
        }
        CompoundNBT tag = stack.func_196082_o();
        if (paragliding) {
            tag.func_74757_a("Paragliding", true);
        } else {
            tag.func_82580_o("Paragliding");
        }
    }
}

