/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.loot;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemModifier
extends LootModifier {
    private final Item item;
    private final int count;

    public ItemModifier(ILootCondition[] conditionsIn) {
        this(conditionsIn, Items.field_190931_a, 0);
    }

    public ItemModifier(ILootCondition[] conditionsIn, Item item, int count) {
        super(conditionsIn);
        this.item = item;
        this.count = count;
    }

    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        generatedLoot.add(new ItemStack((IItemProvider)this.item, this.count));
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<ItemModifier> {
        public ItemModifier read(ResourceLocation location, JsonObject object, ILootCondition[] lootConditions) {
            return new ItemModifier(lootConditions, (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"item"))), JSONUtils.func_151203_m((JsonObject)object, (String)"count"));
        }

        public JsonObject write(ItemModifier instance) {
            JsonObject jsonObject = this.makeConditions(instance.conditions);
            jsonObject.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)instance.item)).toString());
            jsonObject.addProperty("count", (Number)instance.count);
            return jsonObject;
        }
    }
}

