/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.loot;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Random;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.item.ParagliderItem;

public class ParagliderModifier
extends LootModifier {
    public final boolean dekuLeaf;

    public ParagliderModifier(ILootCondition[] conditionsIn) {
        this(conditionsIn, false);
    }

    public ParagliderModifier(ILootCondition[] conditionsIn, boolean dekuLeaf) {
        super(conditionsIn);
        this.dekuLeaf = dekuLeaf;
    }

    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        ParagliderItem item = (ParagliderItem)(this.dekuLeaf ? Contents.DEKU_LEAF : Contents.PARAGLIDER).get();
        ItemStack stack = new ItemStack((IItemProvider)item);
        if (context.func_216032_b().nextBoolean()) {
            item.func_200885_a(stack, ParagliderModifier.getRandomDyeColor(context.func_216032_b()));
        }
        generatedLoot.add(stack);
        return generatedLoot;
    }

    public static int getRandomDyeColor(Random random) {
        return ParagliderModifier.getMixedColor(DyeColor.func_196056_a((int)random.nextInt(16)), DyeColor.func_196056_a((int)random.nextInt(16)));
    }

    public static int getMixedColor(DyeColor dye1, DyeColor dye2) {
        if (dye1 == dye2) {
            return dye1.getColorValue();
        }
        float[] color1 = dye1.func_193349_f();
        float[] color2 = dye2.func_193349_f();
        int red1 = (int)(color1[0] * 255.0f);
        int red2 = (int)(color2[0] * 255.0f);
        int green1 = (int)(color1[1] * 255.0f);
        int green2 = (int)(color2[1] * 255.0f);
        int blue1 = (int)(color1[2] * 255.0f);
        int blue2 = (int)(color2[2] * 255.0f);
        int red = (red1 + red2) / 2;
        int green = (green1 + green2) / 2;
        int blue = (blue1 + blue2) / 2;
        float f3 = (float)(Math.max(red1, Math.max(green1, blue1)) + Math.max(red2, Math.max(green2, blue2))) / 2.0f;
        float f4 = Math.max(red, Math.max(green, blue));
        red = (int)((float)red * f3 / f4);
        green = (int)((float)green * f3 / f4);
        blue = (int)((float)blue * f3 / f4);
        return red << 16 | green << 8 | blue;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<ParagliderModifier> {
        public ParagliderModifier read(ResourceLocation location, JsonObject object, ILootCondition[] lootConditions) {
            return new ParagliderModifier(lootConditions, object.get("dekuLeaf").getAsBoolean());
        }

        public JsonObject write(ParagliderModifier instance) {
            JsonObject jsonObject = this.makeConditions(instance.conditions);
            jsonObject.addProperty("dekuLeaf", Boolean.valueOf(instance.dekuLeaf));
            return jsonObject;
        }
    }
}

