/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.recipe.bargain;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.registries.ForgeRegistryEntry;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.capabilities.ServerPlayerMovement;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.recipe.bargain.BargainPreview;
import tictim.paraglider.recipe.bargain.BargainResult;
import tictim.paraglider.recipe.bargain.StatueBargain;
import tictim.paraglider.utils.ParagliderUtils;
import tictim.paraglider.utils.QuantifiedIngredient;
import tictim.paraglider.utils.QuantifiedItem;
import tictim.paraglider.utils.TooltipFactory;

public class SimpleStatueBargain
implements StatueBargain {
    private final ResourceLocation id;
    private final ResourceLocation bargainOwner;
    private final List<QuantifiedIngredient> itemDemands;
    private final int heartContainerDemands;
    private final int staminaVesselDemands;
    private final int essenceDemands;
    private final List<QuantifiedItem> itemOffers;
    private final int heartContainerOffers;
    private final int staminaVesselOffers;
    private final int essenceOffers;
    @Nullable
    private BargainPreview preview;

    public SimpleStatueBargain(ResourceLocation id, ResourceLocation bargainOwner, List<QuantifiedIngredient> itemDemands, int heartContainerDemands, int staminaVesselDemands, int essenceDemands, List<QuantifiedItem> itemOffers, int heartContainerOffers, int staminaVesselOffers, int essenceOffers) {
        this.id = Objects.requireNonNull(id);
        this.bargainOwner = Objects.requireNonNull(bargainOwner);
        this.itemDemands = ImmutableList.copyOf(itemDemands);
        this.heartContainerDemands = heartContainerDemands;
        this.staminaVesselDemands = staminaVesselDemands;
        this.essenceDemands = essenceDemands;
        this.itemOffers = ImmutableList.copyOf(itemOffers);
        this.heartContainerOffers = heartContainerOffers;
        this.staminaVesselOffers = staminaVesselOffers;
        this.essenceOffers = essenceOffers;
    }

    @Override
    public ResourceLocation getBargainOwner() {
        return this.bargainOwner;
    }

    public List<QuantifiedIngredient> getItemDemands() {
        return this.itemDemands;
    }

    public int getHeartContainerDemands() {
        return this.heartContainerDemands;
    }

    public int getStaminaVesselDemands() {
        return this.staminaVesselDemands;
    }

    public int getEssenceDemands() {
        return this.essenceDemands;
    }

    public List<QuantifiedItem> getItemOffers() {
        return this.itemOffers;
    }

    public int getHeartContainerOffers() {
        return this.heartContainerOffers;
    }

    public int getStaminaVesselOffers() {
        return this.staminaVesselOffers;
    }

    public int getEssenceOffers() {
        return this.essenceOffers;
    }

    @Override
    public BargainPreview getPreview() {
        if (this.preview == null) {
            ArrayList<BargainPreview.Demand> demands = new ArrayList<BargainPreview.Demand>();
            ArrayList<BargainPreview.Offer> offers = new ArrayList<BargainPreview.Offer>();
            for (QuantifiedIngredient itemDemand : this.itemDemands) {
                demands.add(new BargainPreview.Demand(itemDemand.getIngredient().func_193365_a(), itemDemand.getQuantity(), p -> {
                    int count = 0;
                    for (int i = 0; i < p.field_71071_by.func_70302_i_(); ++i) {
                        ItemStack stack = p.field_71071_by.func_70301_a(i);
                        if (stack.func_190926_b() || !itemDemand.test(stack)) continue;
                        count += stack.func_190916_E();
                    }
                    return count;
                }));
            }
            if (this.heartContainerDemands > 0) {
                demands.add(new BargainPreview.Demand(new ItemStack((IItemProvider)Contents.HEART_CONTAINER.get()), this.heartContainerDemands, p -> {
                    ServerPlayerMovement m = ServerPlayerMovement.of((ICapabilityProvider)p);
                    return m != null ? m.getHeartContainers() : 0;
                }, TooltipFactory.heartContainer(this.heartContainerDemands)));
            }
            if (this.staminaVesselDemands > 0) {
                demands.add(new BargainPreview.Demand(new ItemStack((IItemProvider)Contents.STAMINA_VESSEL.get()), this.staminaVesselDemands, p -> {
                    ServerPlayerMovement m = ServerPlayerMovement.of((ICapabilityProvider)p);
                    return m != null ? m.getStaminaVessels() : 0;
                }, TooltipFactory.staminaVessel(this.staminaVesselDemands)));
            }
            if (this.essenceDemands > 0) {
                demands.add(new BargainPreview.Demand(new ItemStack((IItemProvider)Contents.ESSENCE.get()), this.essenceDemands, p -> {
                    ServerPlayerMovement m = ServerPlayerMovement.of((ICapabilityProvider)p);
                    return m != null ? m.getEssence() : 0;
                }, TooltipFactory.essence(this.essenceDemands)));
            }
            for (QuantifiedItem itemOffer : this.itemOffers) {
                offers.add(new BargainPreview.Offer(new ItemStack((IItemProvider)itemOffer.getItem()), itemOffer.getQuantity()));
            }
            if (this.heartContainerOffers > 0) {
                offers.add(new BargainPreview.Offer(new ItemStack((IItemProvider)Contents.HEART_CONTAINER.get()), this.heartContainerOffers, TooltipFactory.heartContainer(this.heartContainerOffers)));
            }
            if (this.staminaVesselOffers > 0) {
                offers.add(new BargainPreview.Offer(new ItemStack((IItemProvider)Contents.STAMINA_VESSEL.get()), this.staminaVesselOffers, TooltipFactory.staminaVessel(this.staminaVesselOffers)));
            }
            if (this.essenceOffers > 0) {
                offers.add(new BargainPreview.Offer(new ItemStack((IItemProvider)Contents.ESSENCE.get()), this.essenceOffers, TooltipFactory.essence(this.essenceOffers)));
            }
            this.preview = new BargainPreview(demands, offers);
        }
        return this.preview;
    }

    public void invalidatePreview() {
        this.preview = null;
    }

    @Override
    public BargainResult bargain(PlayerEntity player, boolean simulate) {
        if (ServerPlayerMovement.of((ICapabilityProvider)player) == null) {
            return BargainResult.failure(BargainResult.FailedReason.OTHER);
        }
        HashSet<BargainResult.FailedReason> reasons = new HashSet<BargainResult.FailedReason>();
        PlayerInventory inventory = player.field_71071_by;
        int[] consumptions = new int[inventory.func_70302_i_()];
        for (QuantifiedIngredient i : this.itemDemands) {
            if (SimpleStatueBargain.test(i, (IInventory)inventory, consumptions)) continue;
            reasons.add(BargainResult.FailedReason.NOT_ENOUGH_ITEMS);
        }
        if (!ParagliderUtils.takeHeartContainers(player, this.heartContainerDemands, true, false)) {
            reasons.add(BargainResult.FailedReason.NOT_ENOUGH_HEART);
        }
        if (!ParagliderUtils.takeStaminaVessels(player, this.staminaVesselDemands, true, false)) {
            reasons.add(BargainResult.FailedReason.NOT_ENOUGH_STAMINA);
        }
        if (!ParagliderUtils.takeEssences(player, this.essenceDemands, true, false)) {
            reasons.add(BargainResult.FailedReason.NOT_ENOUGH_ESSENCE);
        }
        if (!reasons.isEmpty()) {
            return BargainResult.result(reasons);
        }
        if (!ParagliderUtils.giveHeartContainers(player, this.heartContainerOffers - this.heartContainerDemands, true, false)) {
            reasons.add(BargainResult.FailedReason.HEART_FULL);
        }
        if (!ParagliderUtils.giveStaminaVessels(player, this.staminaVesselOffers - this.staminaVesselDemands, true, false)) {
            reasons.add(BargainResult.FailedReason.STAMINA_FULL);
        }
        if (!ParagliderUtils.giveEssences(player, this.essenceOffers - this.essenceDemands, true, false)) {
            reasons.add(BargainResult.FailedReason.ESSENCE_FULL);
        }
        if (!reasons.isEmpty()) {
            return BargainResult.result(reasons);
        }
        if (!simulate) {
            for (int i = 0; i < consumptions.length; ++i) {
                int c = consumptions[i];
                if (c == 0) continue;
                ItemStack stack = inventory.func_70301_a(i);
                if (stack.func_190916_E() > c) {
                    stack.func_190918_g(c);
                    continue;
                }
                if (stack.func_190916_E() != c) {
                    ParagliderMod.LOGGER.error("Quantity of item {} (slot number {}) differs from simulation.", (Object)stack, (Object)i);
                }
                inventory.func_70299_a(i, ItemStack.field_190927_a);
            }
            for (QuantifiedItem item : this.itemOffers) {
                ParagliderUtils.giveItem(player, new ItemStack((IItemProvider)item.getItem(), item.getQuantity()));
            }
            if (this.heartContainerDemands != this.heartContainerOffers && !(this.heartContainerDemands >= this.heartContainerOffers ? ParagliderUtils.takeHeartContainers(player, this.heartContainerDemands - this.heartContainerOffers, false, true) : ParagliderUtils.giveHeartContainers(player, this.heartContainerOffers - this.heartContainerDemands, false, true))) {
                ParagliderMod.LOGGER.error("Heart Container demand of bargain {} failed to resolve after successful simulation.", (Object)this.id);
            }
            if (this.staminaVesselDemands != this.staminaVesselOffers && !(this.staminaVesselDemands >= this.staminaVesselOffers ? ParagliderUtils.takeStaminaVessels(player, this.staminaVesselDemands - this.staminaVesselOffers, false, true) : ParagliderUtils.giveStaminaVessels(player, this.staminaVesselOffers - this.staminaVesselDemands, false, true))) {
                ParagliderMod.LOGGER.error("Stamina Vessel demand of bargain {} failed to resolve after successful simulation.", (Object)this.id);
            }
            if (this.essenceDemands != this.essenceOffers && !(this.essenceDemands >= this.essenceOffers ? ParagliderUtils.takeEssences(player, this.essenceDemands - this.essenceOffers, false, true) : ParagliderUtils.giveEssences(player, this.essenceOffers - this.essenceDemands, false, true))) {
                ParagliderMod.LOGGER.error("Essence demand of bargain {} failed to resolve after successful simulation.", (Object)this.id);
            }
        }
        return BargainResult.success();
    }

    private static boolean test(QuantifiedIngredient quantifiedIngredient, IInventory inventory, int[] consumptions) {
        int amountLeft = quantifiedIngredient.getQuantity();
        for (int i = 0; amountLeft > 0 && i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190916_E() <= consumptions[i] || !quantifiedIngredient.test(stack)) continue;
            int amountToConsume = Math.min(amountLeft, stack.func_190916_E() - consumptions[i]);
            amountLeft -= amountToConsume;
            int n = i;
            consumptions[n] = consumptions[n] + amountToConsume;
        }
        return amountLeft <= 0;
    }

    @Override
    public boolean consumesItem() {
        return !this.itemDemands.isEmpty();
    }

    @Override
    public boolean consumesHeartContainer() {
        return this.heartContainerDemands > 0;
    }

    @Override
    public boolean consumesStaminaVessel() {
        return this.staminaVesselDemands > 0;
    }

    @Override
    public boolean consumesEssence() {
        return this.essenceDemands > 0;
    }

    @Override
    public boolean givesItem() {
        return !this.itemOffers.isEmpty();
    }

    @Override
    public boolean givesHeartContainer() {
        return this.heartContainerOffers > 0;
    }

    @Override
    public boolean givesStaminaVessel() {
        return this.staminaVesselOffers > 0;
    }

    @Override
    public boolean givesEssence() {
        return this.essenceOffers > 0;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)Contents.STATUE_BARGAIN_RECIPE.get();
    }

    public IRecipeType<?> func_222127_g() {
        return Contents.STATUE_BARGAIN_RECIPE_TYPE;
    }

    public String toString() {
        return "SimpleStatueBargain{id=" + this.id + ", bargainOwner=" + this.bargainOwner + ", itemDemands=" + this.itemDemands.stream().map(it -> it.toString()).collect(Collectors.joining(", ")) + ", heartContainerDemands=" + this.heartContainerDemands + ", staminaVesselDemands=" + this.staminaVesselDemands + ", essenceDemands=" + this.essenceDemands + ", itemOffers=" + this.itemOffers.stream().map(it -> it.toString()).collect(Collectors.joining(", ")) + ", heartContainerOffers=" + this.heartContainerOffers + ", staminaVesselOffers=" + this.staminaVesselOffers + ", essenceOffers=" + this.essenceOffers + '}';
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<SimpleStatueBargain> {
        public SimpleStatueBargain read(ResourceLocation recipeId, JsonObject json) {
            int essenceOffers;
            int staminaVesselOffers;
            int heartContainerOffers;
            List<QuantifiedItem> itemOffers;
            int essenceDemands;
            int staminaVesselDemands;
            int heartContainerDemands;
            List<QuantifiedIngredient> itemDemands;
            ResourceLocation bargainOwner = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"owner"));
            JsonObject demands = JSONUtils.func_151218_a((JsonObject)json, (String)"demands", null);
            if (demands != null) {
                JsonArray items = JSONUtils.func_151213_a((JsonObject)demands, (String)"items", null);
                if (items == null || items.size() == 0) {
                    itemDemands = Collections.emptyList();
                } else {
                    itemDemands = new ArrayList();
                    for (JsonElement i : items) {
                        itemDemands.add(new QuantifiedIngredient(JSONUtils.func_151210_l((JsonElement)i, (String)"item")));
                    }
                }
                heartContainerDemands = Math.max(0, JSONUtils.func_151208_a((JsonObject)demands, (String)"heartContainers", (int)0));
                staminaVesselDemands = Math.max(0, JSONUtils.func_151208_a((JsonObject)demands, (String)"staminaVessels", (int)0));
                essenceDemands = Math.max(0, JSONUtils.func_151208_a((JsonObject)demands, (String)"essences", (int)0));
            } else {
                itemDemands = Collections.emptyList();
                heartContainerDemands = 0;
                staminaVesselDemands = 0;
                essenceDemands = 0;
            }
            JsonObject offers = JSONUtils.func_151218_a((JsonObject)json, (String)"offers", null);
            if (offers != null) {
                JsonArray items = JSONUtils.func_151213_a((JsonObject)offers, (String)"items", null);
                if (items == null || items.size() == 0) {
                    itemOffers = Collections.emptyList();
                } else {
                    itemOffers = new ArrayList();
                    for (JsonElement i : items) {
                        ItemStack stack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_151210_l((JsonElement)i, (String)"item"));
                        itemOffers.add(new QuantifiedItem(stack.func_77973_b(), stack.func_190916_E()));
                    }
                }
                heartContainerOffers = Math.max(0, JSONUtils.func_151208_a((JsonObject)offers, (String)"heartContainers", (int)0));
                staminaVesselOffers = Math.max(0, JSONUtils.func_151208_a((JsonObject)offers, (String)"staminaVessels", (int)0));
                essenceOffers = Math.max(0, JSONUtils.func_151208_a((JsonObject)offers, (String)"essences", (int)0));
            } else {
                itemOffers = Collections.emptyList();
                heartContainerOffers = 0;
                staminaVesselOffers = 0;
                essenceOffers = 0;
            }
            return new SimpleStatueBargain(recipeId, bargainOwner, itemDemands, heartContainerDemands, staminaVesselDemands, essenceDemands, itemOffers, heartContainerOffers, staminaVesselOffers, essenceOffers);
        }

        @Nullable
        public SimpleStatueBargain read(ResourceLocation recipeId, PacketBuffer buffer) {
            ResourceLocation owner = buffer.func_192575_l();
            ArrayList<QuantifiedIngredient> itemDemands = new ArrayList<QuantifiedIngredient>();
            int size = buffer.func_150792_a();
            for (int i = 0; i < size; ++i) {
                itemDemands.add(QuantifiedIngredient.read(buffer));
            }
            int heartContainerDemands = buffer.func_150792_a();
            int staminaVesselDemands = buffer.func_150792_a();
            int essenceDemands = buffer.func_150792_a();
            ArrayList<QuantifiedItem> itemOffers = new ArrayList<QuantifiedItem>();
            int size2 = buffer.func_150792_a();
            for (int i = 0; i < size2; ++i) {
                itemOffers.add(QuantifiedItem.read(buffer));
            }
            int heartContainerOffers = buffer.func_150792_a();
            int staminaVesselOffers = buffer.func_150792_a();
            int essenceOffers = buffer.func_150792_a();
            return new SimpleStatueBargain(recipeId, owner, itemDemands, heartContainerDemands, staminaVesselDemands, essenceDemands, itemOffers, heartContainerOffers, staminaVesselOffers, essenceOffers);
        }

        public void write(PacketBuffer buffer, SimpleStatueBargain recipe) {
            buffer.func_192572_a(recipe.getBargainOwner());
            List<QuantifiedIngredient> itemDemands = recipe.getItemDemands();
            buffer.func_150787_b(itemDemands.size());
            for (QuantifiedIngredient demand : itemDemands) {
                demand.write(buffer);
            }
            buffer.func_150787_b(recipe.getHeartContainerDemands());
            buffer.func_150787_b(recipe.getStaminaVesselDemands());
            buffer.func_150787_b(recipe.getEssenceDemands());
            List<QuantifiedItem> itemOffers = recipe.getItemOffers();
            buffer.func_150787_b(itemOffers.size());
            for (QuantifiedItem offer : itemOffers) {
                offer.write(buffer);
            }
            buffer.func_150787_b(recipe.getHeartContainerOffers());
            buffer.func_150787_b(recipe.getStaminaVesselOffers());
            buffer.func_150787_b(recipe.getEssenceOffers());
        }
    }
}

